/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.CpuTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CpuDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    @NotNull
    private final CpuServiceGrpc.CpuServiceBlockingStub myPollingService;
    @NotNull
    private final CpuTable myCpuTable;
    @NotNull
    private final Common.Session mySession;
    private int myProcessId = -1;

    public CpuDataPoller(int processId, @NotNull Common.Session session, @NotNull CpuTable table, @NotNull CpuServiceGrpc.CpuServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.myProcessId = processId;
        this.myCpuTable = table;
        this.myPollingService = pollingService;
        this.mySession = session;
    }

    @Override
    public void poll() throws StatusRuntimeException {
        long getDataStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.CpuDataRequest.Builder request = CpuProfiler.CpuDataRequest.newBuilder().setProcessId(this.myProcessId).setStartTimestamp(getDataStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.CpuDataResponse response = this.myPollingService.getData(request.build());
        for (CpuProfiler.CpuProfilerData data : response.getDataList()) {
            getDataStartNs = Math.max(getDataStartNs, data.getBasicInfo().getEndTimestamp());
            this.myCpuTable.insert(this.mySession, data);
        }
        long getThreadsStartNs = this.myDataRequestStartTimestampNs;
        CpuProfiler.GetThreadsRequest.Builder threadsRequest = CpuProfiler.GetThreadsRequest.newBuilder().setProcessId(this.myProcessId).setStartTimestamp(getThreadsStartNs).setEndTimestamp(Long.MAX_VALUE);
        CpuProfiler.GetThreadsResponse threadsResponse = this.myPollingService.getThreads(threadsRequest.build());
        if (this.myDataRequestStartTimestampNs == Long.MIN_VALUE) {
            CpuProfiler.GetThreadsResponse.ThreadSnapshot snapshot = threadsResponse.getInitialSnapshot();
            getThreadsStartNs = Math.max(getThreadsStartNs, snapshot.getTimestamp());
            this.myCpuTable.insertSnapshot(this.myProcessId, this.mySession, snapshot.getTimestamp(), snapshot.getThreadsList());
        }
        for (CpuProfiler.GetThreadsResponse.Thread thread : threadsResponse.getThreadsList()) {
            List activities = thread.getActivitiesList();
            int count = thread.getActivitiesCount();
            if (count > 0) {
                CpuProfiler.GetThreadsResponse.ThreadActivity last = (CpuProfiler.GetThreadsResponse.ThreadActivity)activities.get(count - 1);
                getThreadsStartNs = Math.max(getThreadsStartNs, last.getTimestamp());
            }
            this.myCpuTable.insertActivities(this.myProcessId, this.mySession, thread.getTid(), thread.getName(), activities);
        }
        this.myDataRequestStartTimestampNs = Math.max(Math.max(this.myDataRequestStartTimestampNs + 1L, getDataStartNs), getThreadsStartNs);
    }
}

