/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.MemoryLiveAllocationTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;

public class MemoryJvmtiDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myPollingService;
    private final MemoryLiveAllocationTable myLiveAllocationTable;
    private int myProcessId = -1;
    private final Common.Session mySession;

    public MemoryJvmtiDataPoller(int processId, Common.Session session, MemoryLiveAllocationTable liveAllocationTable, MemoryServiceGrpc.MemoryServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.myProcessId = processId;
        this.mySession = session;
        this.myLiveAllocationTable = liveAllocationTable;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        if (this.myProcessId == -1) {
            return;
        }
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setProcessId(this.myProcessId).setStartTime(this.myDataRequestStartTimestampNs).setEndTime(Long.MAX_VALUE);
        MemoryProfiler.MemoryData response = this.myPollingService.getJvmtiData(dataRequestBuilder.build());
        for (MemoryProfiler.BatchAllocationSample sample : response.getAllocationSamplesList()) {
            this.myLiveAllocationTable.insertMethodInfo(this.myProcessId, this.mySession, sample.getMethodsList());
            this.myLiveAllocationTable.insertStackInfo(this.myProcessId, this.mySession, sample.getStacksList());
            this.myLiveAllocationTable.insertThreadInfo(this.myProcessId, this.mySession, sample.getThreadInfosList());
            this.myLiveAllocationTable.insertAllocationData(this.myProcessId, this.mySession, sample);
        }
        if (response.getEndTimestamp() > this.myDataRequestStartTimestampNs) {
            this.myDataRequestStartTimestampNs = response.getEndTimestamp();
        }
    }
}

