/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.poller;

import com.android.tools.datastore.database.NetworkTable;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;

public class NetworkDataPoller
extends PollRunner {
    private long myDataRequestStartTimestampNs = Long.MIN_VALUE;
    private long myHttpRangeRequestStartTimeNs = Long.MIN_VALUE;
    private int myProcessId = -1;
    private Common.Session mySession;
    private NetworkTable myNetworkTable;
    NetworkServiceGrpc.NetworkServiceBlockingStub myPollingService;

    public NetworkDataPoller(int processId, Common.Session session, NetworkTable table, NetworkServiceGrpc.NetworkServiceBlockingStub pollingService) {
        super(POLLING_DELAY_NS);
        this.myProcessId = processId;
        this.myNetworkTable = table;
        this.mySession = session;
        this.myPollingService = pollingService;
    }

    @Override
    public void poll() {
        if (this.myProcessId == -1) {
            return;
        }
        NetworkProfiler.NetworkDataRequest.Builder dataRequestBuilder = NetworkProfiler.NetworkDataRequest.newBuilder().setProcessId(this.myProcessId).setStartTimestamp(this.myDataRequestStartTimestampNs).setEndTimestamp(Long.MAX_VALUE).setType(NetworkProfiler.NetworkDataRequest.Type.ALL);
        NetworkProfiler.NetworkDataResponse response = this.myPollingService.getData(dataRequestBuilder.build());
        for (NetworkProfiler.NetworkProfilerData data : response.getDataList()) {
            this.myDataRequestStartTimestampNs = Math.max(this.myDataRequestStartTimestampNs, data.getBasicInfo().getEndTimestamp());
            this.myNetworkTable.insert(data.getBasicInfo().getProcessId(), data);
        }
        this.pollHttpRange();
    }

    private void pollHttpRange() {
        NetworkProfiler.HttpRangeRequest.Builder requestBuilder = NetworkProfiler.HttpRangeRequest.newBuilder().setProcessId(this.myProcessId).setStartTimestamp(this.myHttpRangeRequestStartTimeNs).setEndTimestamp(Long.MAX_VALUE);
        NetworkProfiler.HttpRangeResponse response = this.myPollingService.getHttpRange(requestBuilder.build());
        for (NetworkProfiler.HttpConnectionData data : response.getDataList()) {
            NetworkProfiler.HttpDetailsResponse initialData;
            this.myHttpRangeRequestStartTimeNs = Math.max(this.myHttpRangeRequestStartTimeNs, data.getStartTimestamp() + 1L);
            this.myHttpRangeRequestStartTimeNs = Math.max(this.myHttpRangeRequestStartTimeNs, data.getEndTimestamp() + 1L);
            NetworkProfiler.HttpDetailsResponse request = initialData = this.myNetworkTable.getHttpDetailsResponseById(data.getConnId(), this.mySession, NetworkProfiler.HttpDetailsRequest.Type.REQUEST);
            NetworkProfiler.HttpDetailsResponse responseData = null;
            NetworkProfiler.HttpDetailsResponse body = null;
            NetworkProfiler.HttpDetailsResponse threads = null;
            if (initialData == null) {
                request = this.pollHttpDetails(data.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.REQUEST);
            }
            if (data.getEndTimestamp() != 0L) {
                responseData = this.pollHttpDetails(data.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.RESPONSE);
                body = this.pollHttpDetails(data.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY);
            }
            threads = this.pollHttpDetails(data.getConnId(), NetworkProfiler.HttpDetailsRequest.Type.ACCESSING_THREADS);
            this.myNetworkTable.insertOrReplace(this.myProcessId, this.mySession, request, responseData, body, threads, data);
        }
    }

    private NetworkProfiler.HttpDetailsResponse pollHttpDetails(long id, NetworkProfiler.HttpDetailsRequest.Type type) {
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(id).setType(type).build();
        return this.myPollingService.getHttpDetails(request);
    }
}

