/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.NetworkTable;
import com.android.tools.datastore.poller.NetworkDataPoller;
import com.android.tools.datastore.poller.PollRunner;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class NetworkService
extends NetworkServiceGrpc.NetworkServiceImplBase
implements ServicePassThrough {
    private final NetworkTable myNetworkTable;
    private final Consumer<Runnable> myFetchExecutor;
    private final Map<Integer, PollRunner> myRunners = new HashMap<Integer, PollRunner>();
    private final DataStoreService myService;

    public NetworkService(@NotNull DataStoreService service, Consumer<Runnable> fetchExecutor, @NotNull Map<Common.Session, Long> sessionIdLookup) {
        this.myFetchExecutor = fetchExecutor;
        this.myService = service;
        this.myNetworkTable = new NetworkTable(sessionIdLookup);
    }

    public void getData(NetworkProfiler.NetworkDataRequest request, StreamObserver<NetworkProfiler.NetworkDataResponse> responseObserver) {
        NetworkProfiler.NetworkDataResponse.Builder response = NetworkProfiler.NetworkDataResponse.newBuilder();
        List<NetworkProfiler.NetworkProfilerData> datas = this.myNetworkTable.getNetworkDataByRequest(request);
        response.addAllData(datas);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void startMonitoringApp(NetworkProfiler.NetworkStartRequest request, StreamObserver<NetworkProfiler.NetworkStartResponse> responseObserver) {
        NetworkServiceGrpc.NetworkServiceBlockingStub client = this.myService.getNetworkClient(request.getSession());
        if (client != null) {
            responseObserver.onNext((Object)client.startMonitoringApp(request));
            responseObserver.onCompleted();
            int processId = request.getProcessId();
            this.myRunners.put(processId, new NetworkDataPoller(processId, request.getSession(), this.myNetworkTable, client));
            this.myFetchExecutor.accept(this.myRunners.get(processId));
        } else {
            responseObserver.onNext((Object)NetworkProfiler.NetworkStartResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }
    }

    public void stopMonitoringApp(NetworkProfiler.NetworkStopRequest request, StreamObserver<NetworkProfiler.NetworkStopResponse> responseObserver) {
        NetworkServiceGrpc.NetworkServiceBlockingStub service;
        int processId = request.getProcessId();
        PollRunner runner = this.myRunners.remove(processId);
        if (runner != null) {
            runner.stop();
        }
        if ((service = this.myService.getNetworkClient(request.getSession())) == null) {
            responseObserver.onNext((Object)NetworkProfiler.NetworkStopResponse.getDefaultInstance());
        } else {
            responseObserver.onNext((Object)service.stopMonitoringApp(request));
        }
        responseObserver.onCompleted();
    }

    public void getHttpRange(NetworkProfiler.HttpRangeRequest request, StreamObserver<NetworkProfiler.HttpRangeResponse> responseObserver) {
        NetworkProfiler.HttpRangeResponse.Builder response = NetworkProfiler.HttpRangeResponse.newBuilder();
        List<NetworkProfiler.HttpConnectionData> datas = this.myNetworkTable.getNetworkConnectionDataByRequest(request);
        response.addAllData(datas);
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    public void getHttpDetails(NetworkProfiler.HttpDetailsRequest request, StreamObserver<NetworkProfiler.HttpDetailsResponse> responseObserver) {
        NetworkProfiler.HttpDetailsResponse storedResponse = this.myNetworkTable.getHttpDetailsResponseById(request.getConnId(), request.getSession(), request.getType());
        NetworkProfiler.HttpDetailsResponse.Builder response = NetworkProfiler.HttpDetailsResponse.newBuilder();
        switch (request.getType()) {
            case REQUEST: {
                response.setRequest(storedResponse.getRequest());
                break;
            }
            case RESPONSE: {
                response.setResponse(storedResponse.getResponse());
                break;
            }
            case RESPONSE_BODY: {
                response.setResponseBody(storedResponse.getResponseBody());
                break;
            }
            case ACCESSING_THREADS: {
                response.setAccessingThreads(storedResponse.getAccessingThreads());
            }
        }
        responseObserver.onNext((Object)response.build());
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        return Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myNetworkTable.initialize(connection);
    }
}

