/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.HtmlLabel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.ui.JBColor;
import icons.StudioIllustrations;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NullMonitorStageView
extends StageView<NullMonitorStage> {
    @NotNull
    private NullMonitorStage myStage;
    private HtmlLabel myDisabledMessage;
    private JLabel myTitle;

    public NullMonitorStageView(@NotNull StudioProfilersView profilersView, @NotNull NullMonitorStage stage) {
        super(profilersView, stage);
        this.myStage = stage;
        JPanel topPanel = new JPanel();
        BoxLayout layout = new BoxLayout(topPanel, 1);
        topPanel.setLayout(layout);
        topPanel.add(Box.createVerticalGlue());
        topPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        JLabel picLabel = new JLabel(StudioIllustrations.Common.DISCONNECT);
        picLabel.setHorizontalAlignment(0);
        picLabel.setVerticalAlignment(0);
        picLabel.setAlignmentX(0.5f);
        topPanel.add(picLabel);
        this.myTitle = new JLabel();
        this.myTitle.setHorizontalAlignment(0);
        this.myTitle.setVerticalAlignment(1);
        this.myTitle.setAlignmentX(0.5f);
        this.myTitle.setFont(this.myTitle.getFont().deriveFont(21.0f));
        this.myTitle.setForeground((Color)new JBColor(0, 0xFFFFFF));
        topPanel.add(this.myTitle);
        topPanel.add(Box.createRigidArea(new Dimension(1, 15)));
        this.myDisabledMessage = new HtmlLabel();
        Font font = this.myTitle.getFont().deriveFont(11.0f);
        HtmlLabel.setUpAsHtmlLabel((JEditorPane)this.myDisabledMessage, (Font)font, (Color)ProfilerColors.MESSAGE_COLOR);
        topPanel.add((Component)this.myDisabledMessage);
        topPanel.add(Box.createVerticalGlue());
        this.getComponent().add((Component)topPanel, "Center");
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)NullMonitorStage.Aspect.NULL_MONITOR_TYPE, this::updateTitleAndMessage);
        this.updateTitleAndMessage();
    }

    private void updateTitleAndMessage() {
        this.myTitle.setText(this.myStage.getTitle());
        this.myDisabledMessage.setText("<html><body><div style='text-align: center;'>" + this.myStage.getMessage() + " <a href=\"https://developer.android.com/r/studio-ui/about-profilers.html\">Learn More</a></div></body></html>");
    }

    @Override
    public JComponent getToolbar() {
        return new JPanel();
    }

    @Override
    public boolean needsProcessSelection() {
        return true;
    }
}

