/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerMonitor;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public abstract class ProfilerMonitorView<T extends ProfilerMonitor>
extends AspectObserver {
    private static final int MINIMUM_MONITOR_HEIGHT = JBUI.scale((int)50);
    @NotNull
    private final T myMonitor;
    private JPanel myContainer;

    public ProfilerMonitorView(@NotNull T monitor) {
        this.myMonitor = monitor;
        this.myContainer = new JBPanel();
        this.myContainer.setOpaque(true);
        this.myContainer.setBorder(ProfilerLayout.MONITOR_BORDER);
        this.myContainer.setMinimumSize(new Dimension(0, MINIMUM_MONITOR_HEIGHT));
        this.myContainer.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ProfilerMonitorView.this.myMonitor.setFocus(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ProfilerMonitorView.this.myMonitor.setFocus(false);
            }
        });
        this.myMonitor.addDependency((AspectObserver)this).onChange((Enum)ProfilerMonitor.Aspect.ENABLE, this::monitorEnabledChanged);
        this.monitorEnabledChanged();
        this.myMonitor.addDependency((AspectObserver)this).onChange((Enum)ProfilerMonitor.Aspect.FOCUS, this::focusChanged);
        this.focusChanged();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myContainer;
    }

    protected void focusChanged() {
        if (((ProfilerMonitor)((Object)this.myMonitor)).isEnabled()) {
            boolean highlight = ((ProfilerMonitor)((Object)this.myMonitor)).isFocused() && ((ProfilerMonitor)((Object)this.myMonitor)).canExpand();
            this.myContainer.setBackground(highlight ? ProfilerColors.MONITOR_FOCUSED : ProfilerColors.DEFAULT_BACKGROUND);
        } else {
            this.myContainer.setBackground(ProfilerColors.MONITOR_DISABLED);
        }
    }

    @NotNull
    protected final T getMonitor() {
        return this.myMonitor;
    }

    public float getVerticalWeight() {
        return 1.0f;
    }

    @NotNull
    public String getDisabledMessage() {
        return "Advanced profiling is unavailable for the selected process";
    }

    private void monitorEnabledChanged() {
        this.myContainer.removeAll();
        if (((ProfilerMonitor)((Object)this.getMonitor())).isEnabled()) {
            this.myContainer.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
            this.populateUi(this.myContainer);
        } else {
            this.myContainer.setBackground(ProfilerColors.MONITOR_DISABLED);
            this.myContainer.setLayout((LayoutManager)new TabularLayout("*,Fit,*", "6*,4*"));
            JLabel disabledMessage = new JLabel(this.getDisabledMessage());
            disabledMessage.setHorizontalAlignment(0);
            disabledMessage.setVerticalAlignment(0);
            disabledMessage.setFont(disabledMessage.getFont().deriveFont(15.5f));
            this.myContainer.add((Component)disabledMessage, new TabularLayout.Constraint(0, 0, 3));
            HyperlinkLabel linkToConfigMessage = new HyperlinkLabel();
            linkToConfigMessage.setHyperlinkText("Configure this setting in the ", "Run Configuration", "");
            linkToConfigMessage.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    ProfilerMonitorView.this.myMonitor.getProfilers().getIdeServices().enableAdvancedProfiling();
                }
            });
            this.myContainer.add((Component)linkToConfigMessage, new TabularLayout.Constraint(1, 1));
            linkToConfigMessage.setFont(linkToConfigMessage.getFont().deriveFont(12.0f));
        }
    }

    protected abstract void populateUi(JPanel var1);
}

