/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerTimeline;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.components.JBScrollBar;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.concurrent.TimeUnit;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.plaf.ScrollBarUI;
import org.jetbrains.annotations.NotNull;

public final class ProfilerScrollbar
extends JBScrollBar {
    private static final float VIEW_PERCENTAGE_PER_MOUSEHWEEL_FACTOR = 0.005f;
    private static final long MS_TO_US = TimeUnit.MILLISECONDS.toMicros(1L);
    private static final float STREAMING_POSITION_THRESHOLD_PX = 10.0f;
    @NotNull
    private final ProfilerTimeline myTimeline;
    private final AspectObserver myAspectObserver = new AspectObserver();
    private boolean myUpdating;
    private boolean myCheckStream;

    public ProfilerScrollbar(@NotNull ProfilerTimeline timeline, @NotNull JComponent zoomPanComponent) {
        super(0);
        this.myTimeline = timeline;
        this.myTimeline.getViewRange().addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::modelChanged);
        this.myTimeline.getDataRange().addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::modelChanged);
        ProfilerScrollbarUi scrollbarUi = new ProfilerScrollbarUi();
        this.setUI((ScrollBarUI)((Object)scrollbarUi));
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("UI") && !(evt.getNewValue() instanceof RangeScrollBarUI)) {
                this.setUI((ScrollBarUI)((Object)scrollbarUi));
            }
        });
        this.addAdjustmentListener(e -> {
            if (!this.myUpdating) {
                this.updateModel();
                if (!e.getValueIsAdjusting()) {
                    this.myCheckStream = true;
                }
            }
        });
        zoomPanComponent.addMouseWheelListener(e -> {
            if (this.isScrollable()) {
                boolean isMenuKeyDown;
                int count = e.getWheelRotation();
                double deltaUs = this.getWheelDelta() * (double)count;
                boolean bl = isMenuKeyDown = SystemInfo.isMac ? e.isMetaDown() : e.isControlDown();
                if (isMenuKeyDown) {
                    double anchor = (float)e.getX() / (float)e.getComponent().getWidth();
                    this.myTimeline.zoom(deltaUs, anchor);
                    this.myCheckStream = deltaUs > 0.0;
                } else {
                    this.myTimeline.pan(deltaUs);
                }
                this.myCheckStream = deltaUs > 0.0;
            }
        });
    }

    @VisibleForTesting
    public double getWheelDelta() {
        return this.myTimeline.getViewRange().getLength() * (double)0.005f;
    }

    private void modelChanged() {
        this.myUpdating = true;
        Range dataRangeUs = this.myTimeline.getDataRange();
        Range viewRangeUs = this.myTimeline.getViewRange();
        int dataExtentMs = (int)(dataRangeUs.getLength() / (double)MS_TO_US);
        int viewExtentMs = Math.min(dataExtentMs, (int)(viewRangeUs.getLength() / (double)MS_TO_US));
        int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)MS_TO_US));
        this.setValues(viewRelativeMinMs, viewExtentMs, 0, dataExtentMs);
        this.setBlockIncrement(viewExtentMs);
        this.myUpdating = false;
    }

    private void updateModel() {
        this.myTimeline.setStreaming(false);
        Range dataRangeUs = this.myTimeline.getDataRange();
        Range viewRangeUs = this.myTimeline.getViewRange();
        int valueMs = this.getValue();
        int viewRelativeMinMs = Math.max(0, (int)((viewRangeUs.getMin() - dataRangeUs.getMin()) / (double)MS_TO_US));
        double deltaUs = (long)(valueMs - viewRelativeMinMs) * MS_TO_US;
        viewRangeUs.shift(deltaUs);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myCheckStream && !this.myTimeline.isStreaming() && this.isCloseToMax() && this.myTimeline.canStream()) {
            this.myTimeline.setStreaming(true);
        }
        this.myCheckStream = false;
    }

    private boolean isScrollable() {
        BoundedRangeModel model = this.getModel();
        return model.getMaximum() > model.getExtent();
    }

    private boolean isCloseToMax() {
        BoundedRangeModel model = this.getModel();
        float snapPercentage = 1.0f - 10.0f / (float)this.getWidth();
        return (float)(model.getValue() + model.getExtent()) / (float)model.getMaximum() >= snapPercentage;
    }

    private class ProfilerScrollbarUi
    extends RangeScrollBarUI {
        private ProfilerScrollbarUi() {
        }

        protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds) {
            g.setColor(ProfilerColors.DEFAULT_BACKGROUND);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

