/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class StageView<T extends Stage>
extends AspectObserver {
    private final T myStage;
    private final JPanel myComponent;
    private final StudioProfilersView myProfilersView;

    public StageView(@NotNull StudioProfilersView profilersView, @NotNull T stage) {
        this.myProfilersView = profilersView;
        this.myStage = stage;
        this.myComponent = new JBPanel((LayoutManager)new BorderLayout());
        this.myComponent.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
    }

    @NotNull
    public T getStage() {
        return this.myStage;
    }

    @NotNull
    public StudioProfilersView getProfilersView() {
        return this.myProfilersView;
    }

    @NotNull
    public IdeProfilerComponents getIdeComponents() {
        return this.myProfilersView.getIdeProfilerComponents();
    }

    @NotNull
    public final JComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public final ProfilerTimeline getTimeline() {
        return ((Stage)((Object)this.myStage)).getStudioProfilers().getTimeline();
    }

    @NotNull
    protected JComponent buildTimeAxis(StudioProfilers profilers) {
        JPanel axisPanel = new JPanel(new BorderLayout());
        axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        AxisComponent timeAxis = new AxisComponent(profilers.getViewAxis(), AxisComponent.AxisOrientation.BOTTOM);
        timeAxis.setShowAxisLine(false);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        axisPanel.add((Component)timeAxis, "Center");
        return axisPanel;
    }

    public abstract JComponent getToolbar();

    public boolean needsProcessSelection() {
        return false;
    }
}

