/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioMonitorStage
extends Stage {
    @NotNull
    private List<ProfilerMonitor> myMonitors;
    @Nullable
    private ProfilerMonitor myTooltip;
    private AspectModel<Aspect> myAspect = new AspectModel();

    public AspectModel<Aspect> getAspect() {
        return this.myAspect;
    }

    @Nullable
    public ProfilerMonitor getTooltip() {
        return this.myTooltip;
    }

    public StudioMonitorStage(@NotNull StudioProfilers profiler) {
        super(profiler);
        this.myMonitors = new LinkedList<ProfilerMonitor>();
    }

    @Override
    public void enter() {
        this.getStudioProfilers().getTimeline().getSelectionRange().clear();
        this.myMonitors.clear();
        int processId = this.getStudioProfilers().getProcessId();
        if (processId != -1) {
            for (StudioProfiler profiler : this.getStudioProfilers().getProfilers()) {
                this.myMonitors.add(profiler.newMonitor());
            }
        }
        this.myMonitors.forEach(ProfilerMonitor::enter);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(((Object)((Object)this)).getClass());
    }

    @Override
    public void exit() {
        this.myMonitors.forEach(ProfilerMonitor::exit);
    }

    @NotNull
    public List<ProfilerMonitor> getMonitors() {
        return this.myMonitors;
    }

    public void setTooltip(@Nullable ProfilerMonitor tooltip) {
        if (tooltip != this.myTooltip) {
            this.myTooltip = tooltip;
            this.myMonitors.forEach(monitor -> monitor.setFocus(monitor == tooltip));
            this.myAspect.changed((Enum)Aspect.TOOLTIP);
        }
    }

    static enum Aspect {
        TOOLTIP;

    }
}

