/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.FpsTimer;
import com.android.tools.adtui.model.StopwatchTimer;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.RelativeTimeConverter;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.event.EventProfiler;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.network.NetworkProfiler;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.grpc.StatusRuntimeException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioProfilers
extends AspectModel<ProfilerAspect>
implements Updatable {
    public static final int INVALID_PROCESS_ID = -1;
    public static final int PROFILERS_UPDATE_RATE = 60;
    public static final int TIMELINE_BUFFER = 0;
    private final ProfilerClient myClient;
    private final ProfilerTimeline myTimeline;
    private final List<StudioProfiler> myProfilers;
    @NotNull
    private final IdeProfilerServices myIdeServices;
    private Map<Profiler.Device, List<Profiler.Process>> myProcesses;
    @Nullable
    private Profiler.Process myProcess;
    private Profiler.AgentStatusResponse.Status myAgentStatus;
    @Nullable
    private String myPreferredProcessName;
    private Profiler.Device myDevice;
    @Nullable
    private Common.Session mySessionData;
    @NotNull
    private Stage myStage;
    private Updater myUpdater;
    @NotNull
    private RelativeTimeConverter myRelativeTimeConverter;
    private AxisComponentModel myViewAxis;
    private long myRefreshDevices;
    private boolean myConnected;

    public StudioProfilers(ProfilerClient client, @NotNull IdeProfilerServices ideServices) {
        this(client, ideServices, (StopwatchTimer)new FpsTimer(60));
    }

    @VisibleForTesting
    public StudioProfilers(ProfilerClient client, @NotNull IdeProfilerServices ideServices, @NotNull StopwatchTimer timer) {
        this.myClient = client;
        this.myIdeServices = ideServices;
        this.myPreferredProcessName = null;
        this.myStage = new NullMonitorStage(this);
        this.myStage.enter();
        this.myUpdater = new Updater(timer);
        this.myProfilers = ImmutableList.of((Object)new EventProfiler(this), (Object)new CpuProfiler(this), (Object)new MemoryProfiler(this), (Object)new NetworkProfiler(this));
        this.myRelativeTimeConverter = new RelativeTimeConverter(0L);
        this.myTimeline = new ProfilerTimeline(this.myRelativeTimeConverter);
        this.myProcesses = Maps.newHashMap();
        this.myConnected = false;
        this.myDevice = null;
        this.myProcess = null;
        this.mySessionData = Common.Session.getDefaultInstance();
        this.myViewAxis = new AxisComponentModel(this.myTimeline.getViewRange(), (BaseAxisFormatter)TimeAxisFormatter.DEFAULT);
        this.myViewAxis.setGlobalRange(this.myTimeline.getDataRange());
        this.myUpdater.register((Updatable)this.myTimeline);
        this.myUpdater.register((Updatable)this.myViewAxis);
        this.myUpdater.register((Updatable)this);
    }

    public boolean isStopped() {
        return !this.myUpdater.isRunning();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.myUpdater.stop();
        this.setDevice(null);
        this.changed(ProfilerAspect.STAGE);
    }

    public List<Profiler.Device> getDevices() {
        return Lists.newArrayList(this.myProcesses.keySet());
    }

    public void setPreferredProcessName(@Nullable String name) {
        this.myPreferredProcessName = name;
    }

    public void update(long elapsedNs) {
        this.myRefreshDevices += elapsedNs;
        if (this.myRefreshDevices < TimeUnit.SECONDS.toNanos(1L)) {
            return;
        }
        this.myRefreshDevices = 0L;
        try {
            Profiler.AgentStatusResponse.Status agentStatus;
            Profiler.GetDevicesResponse response = this.myClient.getProfilerClient().getDevices(Profiler.GetDevicesRequest.getDefaultInstance());
            if (!this.myConnected) {
                this.changed(ProfilerAspect.CONNECTION);
            }
            this.myConnected = true;
            HashSet devices = new HashSet(response.getDeviceList());
            HashMap<Profiler.Device, List<Profiler.Process>> newProcesses = new HashMap<Profiler.Device, List<Profiler.Process>>();
            for (Profiler.Device device : devices) {
                Common.Session session = Common.Session.newBuilder().setDeviceSerial(device.getSerial()).setBootId(device.getBootId()).build();
                Profiler.GetProcessesRequest request = Profiler.GetProcessesRequest.newBuilder().setSession(session).build();
                Profiler.GetProcessesResponse processes = this.myClient.getProfilerClient().getProcesses(request);
                int lastProcessId = this.myProcess == null ? 0 : this.myProcess.getPid();
                List processList = processes.getProcessList().stream().filter(process -> process.getState() == Profiler.Process.State.ALIVE || process.getPid() == lastProcessId).collect(Collectors.toList());
                newProcesses.put(device, processList);
            }
            if (!newProcesses.equals(this.myProcesses)) {
                this.myProcesses = newProcesses;
                this.setDevice(this.findPreferredDevice());
                this.setProcess(null);
                this.changed(ProfilerAspect.DEVICES);
                this.changed(ProfilerAspect.PROCESSES);
            }
            if (this.myProcess != null && this.myAgentStatus != (agentStatus = this.getAgentStatus())) {
                this.myAgentStatus = agentStatus;
                this.changed(ProfilerAspect.AGENT);
                if (this.isProcessAlive() && this.myAgentStatus == Profiler.AgentStatusResponse.Status.ATTACHED) {
                    this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                }
            }
        }
        catch (StatusRuntimeException e) {
            this.myConnected = false;
            this.changed(ProfilerAspect.CONNECTION);
            System.err.println("Cannot find profiler service, retrying...");
        }
    }

    @Nullable
    private Profiler.Device findPreferredDevice() {
        if (this.myDevice != null && this.myDevice.getState().equals((Object)Profiler.Device.State.ONLINE) && this.deviceHasAliveProcesses(this.myDevice)) {
            return this.myDevice;
        }
        Set<Profiler.Device> devices = this.myProcesses.keySet();
        Set onlineDevices = devices.stream().filter(device -> device.getState().equals((Object)Profiler.Device.State.ONLINE)).collect(Collectors.toSet());
        if (!onlineDevices.isEmpty()) {
            Profiler.Device anyOnlineDevice = (Profiler.Device)onlineDevices.iterator().next();
            return onlineDevices.stream().filter(this::deviceHasAliveProcesses).findAny().orElse(anyOnlineDevice);
        }
        Profiler.Device anyDevice = devices.isEmpty() ? null : devices.iterator().next();
        return this.myDevice == null ? anyDevice : devices.stream().filter(device -> device.getSerial().equals(this.myDevice.getSerial())).findAny().orElse(anyDevice);
    }

    private boolean deviceHasAliveProcesses(@NotNull Profiler.Device device) {
        List<Profiler.Process> deviceProcesses = this.myProcesses.get(device);
        if (deviceProcesses == null) {
            return false;
        }
        for (Profiler.Process process : deviceProcesses) {
            if (!process.getState().equals((Object)Profiler.Process.State.ALIVE)) continue;
            return true;
        }
        return false;
    }

    public void setDevice(Profiler.Device device) {
        if (!Objects.equals(device, this.myDevice)) {
            if (this.myDevice != null && this.myProcess != null && this.myDevice.getState() == Profiler.Device.State.ONLINE && this.myProcess.getState() == Profiler.Process.State.ALIVE) {
                this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.mySessionData, this.myProcess));
            }
            this.myDevice = device;
            this.changed(ProfilerAspect.DEVICES);
            this.mySessionData = this.myDevice != null ? Common.Session.newBuilder().setDeviceSerial(this.myDevice.getSerial()).setBootId(this.myDevice.getBootId()).build() : null;
            this.setProcess(null);
        }
    }

    public void setMonitoringStage() {
        this.setStage(new StudioMonitorStage(this));
    }

    public void setProcess(@Nullable Profiler.Process process) {
        List<Profiler.Process> processes = this.myProcesses.get(this.myDevice);
        if (process == null || processes == null || !processes.contains(process)) {
            process = this.getPreferredProcess(processes);
        }
        if (!Objects.equals(process, this.myProcess)) {
            if (this.myDevice != null && this.myProcess != null && this.myDevice.getState() == Profiler.Device.State.ONLINE && this.myProcess.getState() == Profiler.Process.State.ALIVE) {
                this.myProfilers.forEach(profiler -> profiler.stopProfiling(this.getSession(), this.myProcess));
            }
            boolean onlyStateChanged = StudioProfilers.isSameProcess(this.myProcess, process);
            this.myProcess = process;
            this.changed(ProfilerAspect.PROCESSES);
            this.myAgentStatus = this.getAgentStatus();
            this.changed(ProfilerAspect.AGENT);
            if (this.myDevice != null && this.myProcess != null && this.myDevice.getState() == Profiler.Device.State.ONLINE && this.myProcess.getState() == Profiler.Process.State.ALIVE) {
                Profiler.TimeResponse response = this.myClient.getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setSession(this.mySessionData).build());
                long currentDeviceTime = response.getTimestampNs();
                long runTime = currentDeviceTime - this.myProcess.getStartTimestampNs();
                this.myRelativeTimeConverter = new RelativeTimeConverter(this.myProcess.getStartTimestampNs() - TimeUnit.SECONDS.toNanos(0L));
                this.myTimeline.reset(this.myRelativeTimeConverter, runTime);
                this.myProfilers.forEach(profiler -> profiler.startProfiling(this.getSession(), this.myProcess));
                if (this.myDevice.getFeatureLevel() >= 26 && this.myIdeServices.getFeatureConfig().isJvmtiAgentEnabled()) {
                    this.myClient.getProfilerClient().attachAgent(Profiler.AgentAttachRequest.newBuilder().setSession(this.getSession()).setProcessId(this.myProcess.getPid()).setAgentLibFileName(String.format("libperfa_%s.so", this.myProcess.getAbiCpuArch())).build());
                }
                this.myIdeServices.getFeatureTracker().trackProfilingStarted();
                if (this.myAgentStatus == Profiler.AgentStatusResponse.Status.ATTACHED) {
                    this.getIdeServices().getFeatureTracker().trackAdvancedProfilingStarted();
                }
            } else {
                this.myTimeline.setIsPaused(true);
            }
            if (!onlyStateChanged) {
                if (this.myProcess == null) {
                    this.setStage(new NullMonitorStage(this));
                } else {
                    this.setStage(new StudioMonitorStage(this));
                }
            }
        }
    }

    @Nullable
    private Profiler.Process getPreferredProcess(List<Profiler.Process> processes) {
        if (processes == null || processes.isEmpty()) {
            return null;
        }
        if (this.myPreferredProcessName != null) {
            for (Profiler.Process process : processes) {
                if (!process.getName().equals(this.myPreferredProcessName) || process.getState() != Profiler.Process.State.ALIVE) continue;
                return process;
            }
        }
        if (this.myProcess != null) {
            for (Profiler.Process process : processes) {
                if (!StudioProfilers.isSameProcess(this.myProcess, process)) continue;
                return process;
            }
        }
        return processes.get(0);
    }

    @NotNull
    private Profiler.AgentStatusResponse.Status getAgentStatus() {
        if (this.myDevice == null || this.myProcess == null) {
            return Profiler.AgentStatusResponse.getDefaultInstance().getStatus();
        }
        Common.Session session = Common.Session.newBuilder().setDeviceSerial(this.myDevice.getSerial()).setBootId(this.myDevice.getBootId()).build();
        Profiler.AgentStatusRequest statusRequest = Profiler.AgentStatusRequest.newBuilder().setProcessId(this.myProcess.getPid()).setSession(session).build();
        return this.myClient.getProfilerClient().getAgentStatus(statusRequest).getStatus();
    }

    private static boolean isSameProcess(@Nullable Profiler.Process process1, @Nullable Profiler.Process process2) {
        return process1 != null && process2 != null && process1.getPid() == process2.getPid() && process1.getName().equals(process2.getName());
    }

    public List<Profiler.Process> getProcesses() {
        List<Profiler.Process> processes = this.myProcesses.get(this.myDevice);
        return processes == null ? ImmutableList.of() : processes;
    }

    @NotNull
    public Stage getStage() {
        return this.myStage;
    }

    public ProfilerClient getClient() {
        return this.myClient;
    }

    public int getProcessId() {
        return this.myProcess != null ? this.myProcess.getPid() : -1;
    }

    @Nullable
    public Common.Session getSession() {
        return this.mySessionData;
    }

    public void setStage(@NotNull Stage stage) {
        this.myStage.exit();
        this.getTimeline().getSelectionRange().clear();
        this.myStage = stage;
        this.myStage.enter();
        this.changed(ProfilerAspect.STAGE);
    }

    @NotNull
    public ProfilerTimeline getTimeline() {
        return this.myTimeline;
    }

    @NotNull
    public RelativeTimeConverter getRelativeTimeConverter() {
        return this.myRelativeTimeConverter;
    }

    public Profiler.Device getDevice() {
        return this.myDevice;
    }

    public Profiler.Process getProcess() {
        return this.myProcess;
    }

    public boolean isProcessAlive() {
        return this.myProcess != null && this.myProcess.getState() == Profiler.Process.State.ALIVE;
    }

    public boolean isLiveAllocationEnabled() {
        return this.getIdeServices().getFeatureConfig().isLiveAllocationsEnabled() && this.getDevice() != null && this.getDevice().getFeatureLevel() >= 26 && this.isAgentAttached();
    }

    public boolean isAgentAttached() {
        return this.myAgentStatus == Profiler.AgentStatusResponse.Status.ATTACHED;
    }

    public List<StudioProfiler> getProfilers() {
        return this.myProfilers;
    }

    public ProfilerMode getMode() {
        return this.myStage.getProfilerMode();
    }

    public void modeChanged() {
        this.changed(ProfilerAspect.MODE);
    }

    @NotNull
    public IdeProfilerServices getIdeServices() {
        return this.myIdeServices;
    }

    public Updater getUpdater() {
        return this.myUpdater;
    }

    public AxisComponentModel getViewAxis() {
        return this.myViewAxis;
    }

    public List<Class<? extends Stage>> getDirectStages() {
        return ImmutableList.of(CpuProfilerStage.class, MemoryProfilerStage.class, NetworkProfilerStage.class);
    }

    @NotNull
    public Class<? extends Stage> getStageClass() {
        return ((Object)((Object)this.myStage)).getClass();
    }

    public void setNewStage(Class<? extends Stage> clazz) {
        try {
            Constructor<? extends Stage> constructor = clazz.getConstructor(StudioProfilers.class);
            Stage stage = constructor.newInstance(new Object[]{this});
            this.setStage(stage);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

