/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatButton;
import com.android.tools.adtui.flat.FlatComboBox;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.flat.FlatToggleButton;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.NullMonitorStage;
import com.android.tools.profilers.NullMonitorStageView;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioMonitorStageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryProfilerStageView;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.function.BiFunction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class StudioProfilersView
extends AspectObserver {
    private final StudioProfilers myProfiler;
    private final ViewBinder<StudioProfilersView, Stage, StageView> myBinder;
    private StageView myStageView;
    private BorderLayout myLayout;
    private JPanel myComponent;
    private JPanel myStageToolbar;
    private JPanel myMonitoringToolbar;
    private JPanel myCommonToolbar;
    private AbstractButton myGoLive;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;

    public StudioProfilersView(@NotNull StudioProfilers profiler, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.myProfiler = profiler;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myStageView = null;
        this.initializeUi();
        this.myBinder = new ViewBinder();
        this.myBinder.bind(StudioMonitorStage.class, StudioMonitorStageView::new);
        this.myBinder.bind(CpuProfilerStage.class, CpuProfilerStageView::new);
        this.myBinder.bind(MemoryProfilerStage.class, MemoryProfilerStageView::new);
        this.myBinder.bind(NetworkProfilerStage.class, NetworkProfilerStageView::new);
        this.myBinder.bind(NullMonitorStage.class, NullMonitorStageView::new);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.STAGE, this::updateStageView);
        this.updateStageView();
    }

    @VisibleForTesting
    public <S extends Stage, T extends StageView> void bind(@NotNull Class<S> clazz, @NotNull BiFunction<StudioProfilersView, S, T> constructor) {
        this.myBinder.bind(clazz, constructor);
    }

    @VisibleForTesting
    public StageView getStageView() {
        return this.myStageView;
    }

    private void initializeUi() {
        this.myLayout = new BorderLayout();
        this.myComponent = new JPanel(this.myLayout);
        FlatComboBox deviceCombo = new FlatComboBox();
        JComboBoxView<Profiler.Device, ProfilerAspect> devices = new JComboBoxView<Profiler.Device, ProfilerAspect>((JComboBox<Profiler.Device>)deviceCombo, this.myProfiler, ProfilerAspect.DEVICES, this.myProfiler::getDevices, this.myProfiler::getDevice, this.myProfiler::setDevice);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, () -> this.myProfiler.getIdeServices().getFeatureTracker().trackChangeDevice(this.myProfiler.getDevice()));
        devices.bind();
        deviceCombo.setRenderer(new DeviceComboBoxRenderer());
        FlatComboBox processCombo = new FlatComboBox();
        JComboBoxView<Profiler.Process, ProfilerAspect> processes = new JComboBoxView<Profiler.Process, ProfilerAspect>((JComboBox<Profiler.Process>)processCombo, this.myProfiler, ProfilerAspect.PROCESSES, this.myProfiler::getProcesses, this.myProfiler::getProcess, this.myProfiler::setProcess);
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, () -> this.myProfiler.getIdeServices().getFeatureTracker().trackChangeProcess(this.myProfiler.getProcess()));
        processes.bind();
        processCombo.setRenderer(new ProcessComboBoxRenderer());
        JPanel toolbar = new JPanel(new BorderLayout());
        JPanel leftToolbar = new JPanel(new FlowLayout(1, 0, 0));
        toolbar.setBorder(AdtUiUtils.DEFAULT_BOTTOM_BORDER);
        toolbar.setPreferredSize(new Dimension(15, JBUI.scale((int)25) + 5));
        this.myMonitoringToolbar = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        this.myMonitoringToolbar.add((Component)deviceCombo);
        this.myMonitoringToolbar.add((Component)processCombo);
        this.myCommonToolbar = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        FlatButton button = new FlatButton(StudioIcons.Common.BACK_ARROW);
        button.addActionListener(action -> {
            this.myProfiler.setMonitoringStage();
            this.myProfiler.getIdeServices().getFeatureTracker().trackGoBack();
        });
        this.myCommonToolbar.add((Component)button);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        FlatComboBox stageCombo = new FlatComboBox();
        JComboBoxView<Class, ProfilerAspect> stages = new JComboBoxView<Class, ProfilerAspect>((JComboBox<Class>)stageCombo, this.myProfiler, ProfilerAspect.STAGE, this.myProfiler::getDirectStages, this.myProfiler::getStageClass, stage -> {
            this.myProfiler.getIdeServices().getFeatureTracker().trackSelectMonitor();
            this.myProfiler.setNewStage((Class<? extends Stage>)stage);
        });
        stageCombo.setRenderer(new StageComboBoxRenderer());
        stages.bind();
        this.myCommonToolbar.add((Component)stageCombo);
        this.myCommonToolbar.add((Component)new FlatSeparator());
        leftToolbar.add(this.myMonitoringToolbar);
        leftToolbar.add(this.myCommonToolbar);
        toolbar.add((Component)leftToolbar, "West");
        JPanel rightToolbar = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        toolbar.add((Component)rightToolbar, "East");
        rightToolbar.setBorder((Border)new JBEmptyBorder(0, 0, 0, 2));
        FlatButton close = new FlatButton(AllIcons.Actions.Cancel);
        close.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Cancel));
        close.addActionListener(event -> this.myProfiler.stop());
        close.setToolTipText("Close");
        rightToolbar.add((Component)close);
        rightToolbar.add((Component)new FlatSeparator());
        ProfilerTimeline timeline = this.myProfiler.getTimeline();
        FlatButton zoomOut = new FlatButton(StudioIcons.Common.ZOOM_OUT);
        zoomOut.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_OUT));
        zoomOut.addActionListener(event -> {
            timeline.zoomOut();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomOut();
        });
        zoomOut.setToolTipText("Zoom out");
        rightToolbar.add((Component)zoomOut);
        FlatButton zoomIn = new FlatButton(StudioIcons.Common.ZOOM_IN);
        zoomIn.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.ZOOM_IN));
        zoomIn.addActionListener(event -> {
            timeline.zoomIn();
            this.myProfiler.getIdeServices().getFeatureTracker().trackZoomIn();
        });
        zoomIn.setToolTipText("Zoom in");
        rightToolbar.add((Component)zoomIn);
        FlatButton resetZoom = new FlatButton(StudioIcons.Common.RESET_ZOOM);
        resetZoom.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Common.RESET_ZOOM));
        resetZoom.addActionListener(event -> {
            timeline.resetZoom();
            this.myProfiler.getIdeServices().getFeatureTracker().trackResetZoom();
        });
        resetZoom.setToolTipText("Reset zoom");
        rightToolbar.add((Component)resetZoom);
        rightToolbar.add((Component)new FlatSeparator());
        this.myGoLive = new FlatToggleButton("Live", StudioIcons.Profiler.Toolbar.GOTO_LIVE);
        this.myGoLive.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.GOTO_LIVE));
        this.myGoLive.setToolTipText("See realtime profiler data");
        this.myGoLive.setFont(this.myGoLive.getFont().deriveFont(13.0f));
        this.myGoLive.setHorizontalTextPosition(2);
        this.myGoLive.setHorizontalAlignment(2);
        this.myGoLive.setBorder((Border)new JBEmptyBorder(3, 8, 3, 7));
        this.myGoLive.setIconTextGap(JBUI.scale((int)8));
        this.myGoLive.addActionListener(event -> {
            timeline.toggleStreaming();
            this.myProfiler.getIdeServices().getFeatureTracker().trackToggleStreaming();
        });
        timeline.addDependency(this).onChange((Enum)ProfilerTimeline.Aspect.STREAMING, this::updateStreaming);
        rightToolbar.add(this.myGoLive);
        Runnable toggleToolButtons = () -> {
            zoomOut.setEnabled(this.myProfiler.isProcessAlive());
            zoomIn.setEnabled(this.myProfiler.isProcessAlive());
            resetZoom.setEnabled(this.myProfiler.isProcessAlive());
            this.myGoLive.setEnabled(this.myProfiler.isProcessAlive());
        };
        this.myProfiler.addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, toggleToolButtons);
        toggleToolButtons.run();
        this.myStageToolbar = new JPanel(new BorderLayout());
        toolbar.add((Component)this.myStageToolbar, "Center");
        this.myComponent.add((Component)toolbar, "North");
        this.updateStreaming();
    }

    private void updateStreaming() {
        this.myGoLive.setSelected(this.myProfiler.getTimeline().isStreaming());
    }

    private void updateStageView() {
        Stage stage = this.myProfiler.getStage();
        if (this.myStageView != null && this.myStageView.getStage() == stage) {
            return;
        }
        this.myStageView = this.myBinder.build(this, stage);
        Component prev = this.myLayout.getLayoutComponent("Center");
        if (prev != null) {
            this.myComponent.remove(prev);
        }
        this.myComponent.add((Component)this.myStageView.getComponent(), "Center");
        this.myComponent.revalidate();
        this.myStageToolbar.removeAll();
        this.myStageToolbar.add((Component)this.myStageView.getToolbar(), "Center");
        this.myStageToolbar.revalidate();
        boolean topLevel = this.myStageView == null || this.myStageView.needsProcessSelection();
        this.myMonitoringToolbar.setVisible(topLevel);
        this.myCommonToolbar.setVisible(!topLevel);
    }

    public JPanel getComponent() {
        return this.myComponent;
    }

    @NotNull
    public IdeProfilerComponents getIdeProfilerComponents() {
        return this.myIdeProfilerComponents;
    }

    @VisibleForTesting
    public static class StageComboBoxRenderer
    extends ColoredListCellRenderer<Class> {
        private static ImmutableMap<Class<? extends Stage>, String> CLASS_TO_NAME = ImmutableMap.of(CpuProfilerStage.class, (Object)"CPU", MemoryProfilerStage.class, (Object)"MEMORY", NetworkProfilerStage.class, (Object)"NETWORK");

        protected void customizeCellRenderer(@NotNull JList list, Class value, int index, boolean selected, boolean hasFocus) {
            String name = (String)CLASS_TO_NAME.get((Object)value);
            this.append(name == null ? "[UNKNOWN]" : name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @VisibleForTesting
    public static class ProcessComboBoxRenderer
    extends ColoredListCellRenderer<Profiler.Process> {
        @NotNull
        private final String myEmptyText = "No debuggable processes";

        protected void customizeCellRenderer(@NotNull JList list, Profiler.Process value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.renderProcessName(value);
            } else {
                this.append(this.getEmptyText(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private void renderProcessName(@NotNull Profiler.Process process) {
            String name = process.getName();
            int index = name.lastIndexOf(46);
            this.append(name.substring(0, index + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.append(name.substring(index + 1), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(String.format(" (%1$d)", process.getPid()), SimpleTextAttributes.GRAY_ATTRIBUTES);
            if (process.getState() != Profiler.Process.State.ALIVE) {
                this.append(" [DEAD]", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }

        @NotNull
        @VisibleForTesting
        public String getEmptyText() {
            return "No debuggable processes";
        }
    }

    @VisibleForTesting
    public static class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<Profiler.Device> {
        @NotNull
        private final String myEmptyText = "No connected devices";

        protected void customizeCellRenderer(@NotNull JList list, Profiler.Device value, int index, boolean selected, boolean hasFocus) {
            if (value != null) {
                this.renderDeviceName(value);
            } else {
                this.append(this.getEmptyText(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        public void renderDeviceName(@NotNull Profiler.Device d) {
            String serial;
            String suffix;
            String manufacturer = d.getManufacturer();
            String model = d.getModel();
            if (model.endsWith(suffix = String.format("-%s", serial = d.getSerial()))) {
                model = model.substring(0, model.length() - suffix.length());
            }
            if (!StringUtil.isEmpty((String)manufacturer)) {
                this.append(String.format("%s ", manufacturer), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
            this.append(model, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.append(String.format(" (%1$s)", serial), SimpleTextAttributes.GRAY_ATTRIBUTES);
            Profiler.Device.State state = d.getState();
            if (state != Profiler.Device.State.ONLINE && state != Profiler.Device.State.UNSPECIFIED) {
                this.append(String.format(" [%s]", state), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            }
        }

        @NotNull
        @VisibleForTesting
        public String getEmptyText() {
            return "No connected devices";
        }
    }
}

