/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DefaultHNode;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.BottomUpNode;
import com.android.tools.profilers.cpu.BottomUpTreeModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuTreeNode;
import com.android.tools.profilers.cpu.MethodModel;
import com.android.tools.profilers.cpu.TopDownNode;
import com.android.tools.profilers.cpu.TopDownTreeModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CaptureModel {
    private static final double EPSILON = 1.0E-5;
    static final int NO_THREAD = -1;
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private CpuCapture myCapture;
    private int myThread;
    @NotNull
    private ClockType myClockType = ClockType.GLOBAL;
    @Nullable
    private Details myDetails;
    private final Range myCaptureConvertedRange;

    CaptureModel(@NotNull CpuProfilerStage stage) {
        this.myStage = stage;
        this.myCaptureConvertedRange = new Range();
        this.myThread = -1;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        selection.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateCaptureConvertedRange);
        this.myCaptureConvertedRange.addDependency(this.myStage.getAspect()).onChange((Enum)Range.Aspect.RANGE, this::updateSelectionRange);
    }

    void setCapture(@Nullable CpuCapture capture) {
        if (this.myCapture == capture) {
            return;
        }
        this.myCapture = capture;
        if (this.myCapture != null) {
            this.setThread(this.myThread != -1 ? this.myThread : capture.getMainThreadId());
            this.myCapture.updateClockType(this.myClockType);
        } else {
            this.setThread(-1);
        }
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE);
    }

    @Nullable
    CpuCapture getCapture() {
        return this.myCapture;
    }

    void setThread(int thread) {
        if (this.myThread == thread) {
            return;
        }
        this.myThread = thread;
        this.rebuildDetails();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
    }

    int getThread() {
        return this.myThread;
    }

    void setClockType(@NotNull ClockType type) {
        if (this.myClockType == type) {
            return;
        }
        this.myClockType = type;
        if (this.myCapture != null) {
            this.myCapture.updateClockType(this.myClockType);
        }
        this.rebuildDetails();
        this.updateCaptureConvertedRange();
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CLOCK_TYPE);
    }

    @NotNull
    ClockType getClockType() {
        return this.myClockType;
    }

    void setDetails(@Nullable Details.Type type) {
        if (type != null && this.myDetails != null && type == this.myDetails.getType()) {
            return;
        }
        this.buildDetails(type);
    }

    @Nullable
    Details getDetails() {
        return this.myDetails;
    }

    private void rebuildDetails() {
        if (this.myCapture == null) {
            this.buildDetails(null);
        } else {
            this.buildDetails(this.myDetails == null ? Details.Type.CALL_CHART : this.myDetails.getType());
        }
    }

    private void buildDetails(@Nullable Details.Type type) {
        this.updateCaptureConvertedRange();
        this.myDetails = type != null ? type.build(this.myCaptureConvertedRange, this.getNode()) : null;
        this.myStage.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_DETAILS);
    }

    @Nullable
    private CaptureNode getNode() {
        return this.myCapture != null ? this.myCapture.getCaptureNode(this.myThread) : null;
    }

    private void updateCaptureConvertedRange() {
        CaptureNode node;
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setConvertedRange(selection.getMin(), selection.getMax());
            return;
        }
        double convertedMin = (double)node.getStartThread() + node.threadGlobalRatio() * (selection.getMin() - (double)node.getStartGlobal());
        double convertedMax = convertedMin + node.threadGlobalRatio() * selection.getLength();
        this.setConvertedRange(convertedMin, convertedMax);
    }

    private void updateSelectionRange() {
        CaptureNode node;
        ClockType clockType = this.getClockType();
        CpuCapture capture = this.getCapture();
        if (clockType == ClockType.GLOBAL || capture == null || (node = capture.getCaptureNode(this.getThread())) == null) {
            this.setSelectionRange(this.myCaptureConvertedRange.getMin(), this.myCaptureConvertedRange.getMax());
            return;
        }
        double threadToGlobal = 1.0 / node.threadGlobalRatio();
        double convertedMin = (double)node.getStartGlobal() + threadToGlobal * (this.myCaptureConvertedRange.getMin() - (double)node.getStartThread());
        double convertedMax = convertedMin + threadToGlobal * this.myCaptureConvertedRange.getLength();
        this.setSelectionRange(convertedMin, convertedMax);
    }

    private void setSelectionRange(double min, double max) {
        Range selection = this.myStage.getStudioProfilers().getTimeline().getSelectionRange();
        if (Math.abs(selection.getMin() - min) > 1.0E-5 || Math.abs(selection.getMax() - max) > 1.0E-5) {
            selection.set(min, max);
        }
    }

    private void setConvertedRange(double min, double max) {
        if (Math.abs(this.myCaptureConvertedRange.getMin() - min) > 1.0E-5 || Math.abs(this.myCaptureConvertedRange.getMax() - max) > 1.0E-5) {
            this.myCaptureConvertedRange.set(min, max);
        }
    }

    public static class FlameChart
    implements Details {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private HNode<MethodModel> myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        public FlameChart(@NotNull Range selectionRange, @Nullable CaptureNode captureNode) {
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNode == null) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            this.myTopDownNode = new TopDownNode(captureNode);
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToHNode(this.myTopDownNode, start, 0);
            } else {
                this.myFlameNode = null;
            }
            this.myFlameRange.set(this.mySelectionRange);
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            return this.myFlameRange;
        }

        @Nullable
        public HNode<MethodModel> getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            return this.myAspectModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.FLAME_CHART;
        }

        private DefaultHNode<MethodModel> convertToHNode(@NotNull TopDownNode topDown, double start, int depth) {
            TopDownNode child;
            assert (topDown.getTotal() > 0.0);
            DefaultHNode node = new DefaultHNode((Object)topDown.getNodes().get(0).getData(), (long)start, (long)(start + topDown.getTotal()));
            node.setDepth(depth);
            for (TopDownNode child2 : topDown.getChildren()) {
                child2.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort(Comparator.comparingDouble(CpuTreeNode::getTotal).reversed());
            Iterator iterator = sortedChildren.iterator();
            while (iterator.hasNext() && (child = (TopDownNode)iterator.next()).getTotal() != 0.0) {
                node.addChild(this.convertToHNode(child, start, depth + 1));
                start += child.getTotal();
            }
            return node;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    implements Details {
        @NotNull
        private final Range myRange;
        @Nullable
        private HNode<MethodModel> myNode;

        public CallChart(@NotNull Range range, @Nullable CaptureNode node) {
            this.myRange = range;
            this.myNode = node;
        }

        @NotNull
        public Range getRange() {
            return this.myRange;
        }

        @Nullable
        public HNode<MethodModel> getNode() {
            return this.myNode;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.CALL_CHART;
        }
    }

    public static class BottomUp
    implements Details {
        @Nullable
        private BottomUpTreeModel myModel;

        public BottomUp(@NotNull Range range, @Nullable CaptureNode node) {
            this.myModel = node == null ? null : new BottomUpTreeModel(range, new BottomUpNode(node));
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.BOTTOM_UP;
        }
    }

    public static class TopDown
    implements Details {
        @Nullable
        private TopDownTreeModel myModel;

        public TopDown(@NotNull Range range, @Nullable CaptureNode node) {
            this.myModel = node == null ? null : new TopDownTreeModel(range, new TopDownNode(node));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Details.Type getType() {
            return Details.Type.TOP_DOWN;
        }
    }

    public static interface Details {
        public Type getType();

        public static enum Type {
            TOP_DOWN(TopDown::new),
            BOTTOM_UP(BottomUp::new),
            CALL_CHART(CallChart::new),
            FLAME_CHART(FlameChart::new);

            @NotNull
            private final BiFunction<Range, CaptureNode, Details> myBuilder;

            private Type(BiFunction<Range, CaptureNode, Details> builder) {
                this.myBuilder = builder;
            }

            public Details build(Range range, CaptureNode node) {
                return this.myBuilder.apply(range, node);
            }
        }
    }
}

