/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.HNode;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.MethodModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureNode
implements HNode<MethodModel> {
    private long myStartGlobal;
    private long myEndGlobal;
    private long myStartThread;
    private long myEndThread;
    @NotNull
    private final List<CaptureNode> myChildren = new ArrayList<CaptureNode>();
    @NotNull
    private ClockType myClockType = ClockType.GLOBAL;
    private CaptureNode myParent;
    private MethodModel myMethodModel;
    private int myDepth = 0;

    public void addChild(CaptureNode node) {
        this.myChildren.add(node);
        node.myParent = this;
    }

    @NotNull
    public List<CaptureNode> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    @NotNull
    public CaptureNode getChildAt(int index) {
        return this.myChildren.get(index);
    }

    @Nullable
    public CaptureNode getParent() {
        return this.myParent;
    }

    @Nullable
    public CaptureNode getFirstChild() {
        return this.getChildCount() == 0 ? null : this.getChildAt(0);
    }

    @Nullable
    public CaptureNode getLastChild() {
        return this.getChildCount() == 0 ? null : this.getChildAt(this.getChildCount() - 1);
    }

    public long getStart() {
        return this.myClockType == ClockType.THREAD ? this.myStartThread : this.myStartGlobal;
    }

    public long getEnd() {
        return this.myClockType == ClockType.THREAD ? this.myEndThread : this.myEndGlobal;
    }

    @Nullable
    public MethodModel getData() {
        return this.myMethodModel;
    }

    public int getDepth() {
        return this.myDepth;
    }

    public void setStartGlobal(long startGlobal) {
        this.myStartGlobal = startGlobal;
    }

    public long getStartGlobal() {
        return this.myStartGlobal;
    }

    public void setEndGlobal(long endGlobal) {
        this.myEndGlobal = endGlobal;
    }

    public long getEndGlobal() {
        return this.myEndGlobal;
    }

    public void setStartThread(long startThread) {
        this.myStartThread = startThread;
    }

    public long getStartThread() {
        return this.myStartThread;
    }

    public void setEndThread(long endThread) {
        this.myEndThread = endThread;
    }

    public long getEndThread() {
        return this.myEndThread;
    }

    public void setClockType(@NotNull ClockType clockType) {
        this.myClockType = clockType;
    }

    public double threadGlobalRatio() {
        long durationThread = this.myEndThread - this.myStartThread;
        long durationGlobal = this.myEndGlobal - this.myStartGlobal;
        return (double)durationThread / (double)durationGlobal;
    }

    @NotNull
    public ClockType getClockType() {
        return this.myClockType;
    }

    @Nullable
    public MethodModel getMethodModel() {
        return this.myMethodModel;
    }

    public void setMethodModel(MethodModel methodModel) {
        this.myMethodModel = methodModel;
    }

    public void setDepth(int depth) {
        this.myDepth = depth;
    }
}

