/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCapture
implements ConfigurableDurationData {
    public static final String MAIN_THREAD_NAME = "main";
    private final int myMainThreadId;
    @NotNull
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTrees;
    @NotNull
    private Range myRange;
    @NotNull
    private ClockType myClockType;

    public CpuCapture(@NotNull Range captureRange, @NotNull Map<CpuThreadInfo, CaptureNode> captureTrees) {
        this.myRange = captureRange;
        this.myCaptureTrees = captureTrees;
        Map.Entry<CpuThreadInfo, CaptureNode> main = null;
        boolean foundMainThread = false;
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : captureTrees.entrySet()) {
            if (entry.getKey().getName().equals(MAIN_THREAD_NAME)) {
                main = entry;
                foundMainThread = true;
            }
            if (foundMainThread || main != null && main.getValue().duration() >= entry.getValue().duration()) continue;
            main = entry;
        }
        assert (main != null);
        this.myMainThreadId = ((CpuThreadInfo)main.getKey()).getId();
        CaptureNode mainNode = this.getCaptureNode(this.myMainThreadId);
        assert (mainNode != null);
        this.myClockType = mainNode.getClockType();
    }

    public int getMainThreadId() {
        return this.myMainThreadId;
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    @Nullable
    public CaptureNode getCaptureNode(int threadId) {
        for (Map.Entry<CpuThreadInfo, CaptureNode> entry : this.myCaptureTrees.entrySet()) {
            if (entry.getKey().getId() != threadId) continue;
            return entry.getValue();
        }
        return null;
    }

    @NotNull
    Set<CpuThreadInfo> getThreads() {
        return this.myCaptureTrees.keySet();
    }

    public boolean containsThread(int threadId) {
        return this.myCaptureTrees.keySet().stream().anyMatch(info -> info.getId() == threadId);
    }

    public long getDuration() {
        return (long)this.myRange.getLength();
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public boolean canSelectPartialRange() {
        return true;
    }

    public void updateClockType(@NotNull ClockType clockType) {
        if (this.myClockType == clockType) {
            return;
        }
        this.myClockType = clockType;
        for (CaptureNode tree : this.myCaptureTrees.values()) {
            CpuCapture.updateClockType(tree, clockType);
        }
    }

    private static void updateClockType(@Nullable CaptureNode node, @NotNull ClockType clockType) {
        if (node == null) {
            return;
        }
        node.setClockType(clockType);
        for (CaptureNode child : node.getChildren()) {
            CpuCapture.updateClockType(child, clockType);
        }
    }
}

