/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.IdeProfilerServices;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.art.ArtTraceParser;
import com.android.tools.profilers.cpu.simpleperf.SimplePerfTraceParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuCaptureParser {
    @VisibleForTesting
    static final int MAX_SUPPORTED_TRACE_SIZE = 0x6400000;
    private final Map<Integer, CompletableFuture<CpuCapture>> myCaptures;
    @NotNull
    private final IdeProfilerServices myServices;

    public CpuCaptureParser(@NotNull IdeProfilerServices services) {
        this.myServices = services;
        this.myCaptures = new HashMap();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuCaptureParser.class);
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCapture(int traceId) {
        return this.myCaptures.get(traceId);
    }

    @Nullable
    public CompletableFuture<CpuCapture> parse(int traceId, @NotNull ByteString traceData, CpuProfiler.CpuProfilerType profilerType) {
        if (!this.myCaptures.containsKey(traceId)) {
            if (traceData.size() <= 0x6400000) {
                this.myCaptures.put(traceId, this.createCaptureFuture(traceData, profilerType));
            } else {
                Runnable yesCallback = () -> {
                    CpuCaptureParser.getLogger().warn(String.format("Parsing long (%d bytes) trace file.", traceData.size()));
                    this.myCaptures.put(traceId, this.createCaptureFuture(traceData, profilerType));
                };
                Runnable noCallback = () -> {
                    CpuCaptureParser.getLogger().warn(String.format("Parsing of a long (%d bytes) trace file was aborted by the user.", traceData.size()));
                    this.myCaptures.put(traceId, null);
                };
                this.myServices.openParseLargeTracesDialog(yesCallback, noCallback);
            }
        }
        return this.myCaptures.get(traceId);
    }

    private CompletableFuture<CpuCapture> createCaptureFuture(ByteString traceBytes, CpuProfiler.CpuProfilerType profilerType) {
        return CompletableFuture.supplyAsync(() -> CpuCaptureParser.traceBytesToCapture(traceBytes, profilerType), this.myServices.getPoolExecutor());
    }

    private static CpuCapture traceBytesToCapture(@NotNull ByteString traceData, CpuProfiler.CpuProfilerType profilerType) {
        try {
            TraceParser parser;
            File trace = FileUtil.createTempFile((String)"cpu_trace", (String)".trace");
            try (FileOutputStream out = new FileOutputStream(trace);){
                out.write(traceData.toByteArray());
            }
            if (profilerType == CpuProfiler.CpuProfilerType.ART) {
                parser = new ArtTraceParser();
            } else if (profilerType == CpuProfiler.CpuProfilerType.SIMPLE_PERF) {
                parser = new SimplePerfTraceParser();
            } else {
                throw new IllegalStateException("Trace file cannot be parsed. Profiler type (ART or simpleperf) needs to be set.");
            }
            parser.parse(trace);
            return new CpuCapture(parser.getRange(), parser.getCaptureTrees());
        }
        catch (IOException | BufferUnderflowException e) {
            throw new IllegalStateException(e);
        }
    }
}

