/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuUsage;
import org.jetbrains.annotations.NotNull;

public class CpuMonitor
extends ProfilerMonitor {
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 2, 10, "%");
    @NotNull
    private final CpuUsage myThisProcessCpuUsage;
    @NotNull
    private final AxisComponentModel myCpuUsageAxis;
    @NotNull
    private final Legends myLegends;
    @NotNull
    private final Legends myTooltipLegends;

    public CpuMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myThisProcessCpuUsage = new CpuUsage(profilers);
        this.myCpuUsageAxis = new AxisComponentModel(this.myThisProcessCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER);
        this.myCpuUsageAxis.setClampToMajorTicks(true);
        this.myLegends = new Legends(this.myThisProcessCpuUsage, profilers.getTimeline().getDataRange(), 100);
        this.myTooltipLegends = new Legends(this.myThisProcessCpuUsage, profilers.getTimeline().getTooltipRange(), 0);
    }

    @Override
    public String getName() {
        return "CPU";
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myThisProcessCpuUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myLegends);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegends);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myThisProcessCpuUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myLegends);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegends);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new CpuProfilerStage(this.myProfilers));
    }

    @NotNull
    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    @NotNull
    public Legends getLegends() {
        return this.myLegends;
    }

    @NotNull
    public CpuUsage getThisProcessCpuUsage() {
        return this.myThisProcessCpuUsage;
    }

    public Legends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    public static class Legends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;

        public Legends(@NotNull CpuUsage usage, @NotNull Range range, int updateFrequencyMs) {
            super(updateFrequencyMs);
            this.myCpuLegend = new SeriesLegend(usage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, range);
            this.add((Legend)this.myCpuLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }
    }
}

