/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CaptureModel;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new ProfilingConfiguration();
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new ProfilingConfiguration();
    private static final long INVALID_CAPTURE_START_TIME = Long.MAX_VALUE;
    private static final int O_API_LEVEL = 26;
    private static final CaptureModel.Details.Type DEFAULT_CAPTURE_DETAILS = CaptureModel.Details.Type.CALL_CHART;
    private final CpuThreadsModel myThreadsStates;
    private final AxisComponentModel myCpuUsageAxis;
    private final AxisComponentModel myThreadCountAxis;
    private final AxisComponentModel myTimeAxisGuide;
    private final DetailedCpuUsage myCpuUsage;
    private final CpuStageLegends myLegends;
    private final DurationDataModel<CpuTraceInfo> myTraceDurations;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    @NotNull
    private final DurationDataModel<DefaultDurationData> myInProgressTraceDuration;
    @NotNull
    private final DefaultDataSeries<DefaultDurationData> myInProgressTraceSeries;
    @NotNull
    private final CpuTraceDataSeries myCpuTraceDataSeries;
    private final AspectModel<CpuProfilerAspect> myAspect = new AspectModel();
    @NotNull
    private final CaptureModel myCaptureModel;
    @NotNull
    private CaptureState myCaptureState = CaptureState.IDLE;
    private long myCaptureStartTimeNs;
    private CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private ProfilingConfiguration myProfilingConfiguration;
    private List<ProfilingConfiguration> myProfilingConfigurations;
    private ProfilingConfiguration myActiveConfig;
    @NotNull
    private final UpdatableManager myUpdatableManager;
    private final CpuCaptureParser myCaptureParser;
    @Nullable
    private Tooltip myTooltip;

    public CpuProfilerStage(final @NotNull StudioProfilers profilers) {
        super(profilers);
        this.myCpuTraceDataSeries = new CpuTraceDataSeries();
        Range viewRange = this.getStudioProfilers().getTimeline().getViewRange();
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.myCpuUsage = new DetailedCpuUsage(profilers);
        this.myCpuUsageAxis = new AxisComponentModel(this.myCpuUsage.getCpuRange(), (BaseAxisFormatter)CPU_USAGE_FORMATTER);
        this.myCpuUsageAxis.setClampToMajorTicks(true);
        this.myThreadCountAxis = new AxisComponentModel(this.myCpuUsage.getThreadRange(), (BaseAxisFormatter)NUM_THREADS_AXIS);
        this.myThreadCountAxis.setClampToMajorTicks(true);
        this.myTimeAxisGuide = new AxisComponentModel(viewRange, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT_WITHOUT_MINOR_TICKS);
        this.myTimeAxisGuide.setGlobalRange(dataRange);
        this.myLegends = new CpuStageLegends(this.myCpuUsage, dataRange);
        this.myTraceDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.getCpuTraceDataSeries()));
        this.myThreadsStates = new CpuThreadsModel(viewRange, this, this.getStudioProfilers().getProcessId(), this.getStudioProfilers().getSession());
        this.myInProgressTraceSeries = new DefaultDataSeries();
        this.myInProgressTraceDuration = new DurationDataModel(new RangedSeries(viewRange, this.myInProgressTraceSeries));
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = new SelectionModel(selectionRange, viewRange);
        this.mySelectionModel.addConstraint(this.myTraceDurations);
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
            }
        });
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.updateProfilingState();
        this.updateProfilingConfigurations();
        this.myCaptureModel = new CaptureModel(this);
        this.myUpdatableManager = new UpdatableManager(this.getStudioProfilers().getUpdater());
        this.myCaptureParser = new CpuCaptureParser(this.getStudioProfilers().getIdeServices());
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuUsageAxis;
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myThreadCountAxis;
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myTimeAxisGuide;
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuUsage;
    }

    public CpuStageLegends getLegends() {
        return this.myLegends;
    }

    public void setTooltip(@Nullable Tooltip.Type type) {
        if (type != null && this.myTooltip != null && type.equals((Object)this.myTooltip.getType())) {
            return;
        }
        if (this.myTooltip != null) {
            this.myTooltip.dispose();
        }
        this.myTooltip = type != null ? type.build(this) : null;
        this.getAspect().changed((Enum)CpuProfilerAspect.TOOLTIP);
    }

    @Nullable
    public Tooltip getTooltip() {
        return this.myTooltip;
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myTraceDurations;
    }

    @NotNull
    public DurationDataModel<DefaultDurationData> getInProgressTraceDuration() {
        return this.myInProgressTraceDuration;
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @Override
    public void enter() {
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().register(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().register(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this::updateProfilingConfigurations);
        this.getStudioProfilers().getTimeline().getSelectionRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::selectionChanged);
    }

    @Override
    public void exit() {
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myTraceDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myInProgressTraceDuration);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCpuUsageAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadCountAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myTimeAxisGuide);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myThreadsStates);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.getStudioProfilers().removeDependencies(this);
        this.getStudioProfilers().getTimeline().getSelectionRange().removeDependencies((AspectObserver)this);
        this.mySelectionModel.clearListeners();
        this.myUpdatableManager.releaseAll();
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myUpdatableManager;
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myAspect;
    }

    public void startCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStartRequest request = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setMode(this.myProfilingConfiguration.getMode()).setProfilerType(this.myProfilingConfiguration.getProfilerType()).setBufferSizeInMb(this.myProfilingConfiguration.getProfilingBufferSizeInMb()).setSamplingIntervalUs(this.myProfilingConfiguration.getProfilingSamplingIntervalUs()).build();
        this.setCaptureState(CaptureState.STARTING);
        CompletableFuture.supplyAsync(() -> cpuService.startProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(response -> this.startCapturingCallback((CpuProfiler.CpuProfilingAppStartResponse)response, this.myProfilingConfiguration), this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private void startCapturingCallback(CpuProfiler.CpuProfilingAppStartResponse response, ProfilingConfiguration profilingConfiguration) {
        if (response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            this.setActiveConfig(profilingConfiguration.getProfilerType(), profilingConfiguration.getMode(), profilingConfiguration.getProfilingBufferSizeInMb(), profilingConfiguration.getProfilingSamplingIntervalUs());
            this.setCaptureState(CaptureState.CAPTURING);
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            this.getStudioProfilers().getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    public void stopCapturing() {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.CpuProfilingAppStopRequest request = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setProfilerType(this.myActiveConfig.getProfilerType()).setSession(this.getStudioProfilers().getSession()).build();
        this.setCaptureState(CaptureState.STOPPING);
        this.myInProgressTraceSeries.clear();
        CompletableFuture.supplyAsync(() -> cpuService.stopProfilingApp(request), this.getStudioProfilers().getIdeServices().getPoolExecutor()).thenAcceptAsync(this::stopCapturingCallback, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    public long getCaptureElapsedTimeUs() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNs() - this.myCaptureStartTimeNs);
    }

    private void stopCapturingCallback(CpuProfiler.CpuProfilingAppStopResponse response) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myActiveConfig);
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + response.getStatus());
            CpuProfilerStage.getLogger().warn(response.getErrorMessage());
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.STOP_CAPTURING_FAILURE);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        } else {
            this.setCaptureState(CaptureState.PARSING);
            ByteString traceBytes = response.getTrace();
            captureMetadata.setTraceFileSizeBytes(traceBytes.size());
            this.handleCaptureParsing(response.getTraceId(), traceBytes, captureMetadata);
        }
    }

    private void handleCaptureParsing(int traceId, ByteString traceBytes, CpuCaptureMetadata captureMetadata) {
        long beforeParsingTime = System.currentTimeMillis();
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.parse(traceId, traceBytes, this.myActiveConfig.getProfilerType());
        if (capture == null) {
            this.setCaptureState(CaptureState.IDLE);
            captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.USER_ABORTED_PARSING);
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
            return;
        }
        Consumer<CpuCapture> parsingCallback = parsedCapture -> {
            this.myCaptureState = CaptureState.IDLE;
            if (parsedCapture != null) {
                this.setAndSelectCapture((CpuCapture)parsedCapture);
                this.setCaptureDetails(DEFAULT_CAPTURE_DETAILS);
                this.saveTraceInfo(traceId, (CpuCapture)parsedCapture);
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.SUCCESS);
                captureMetadata.setParsingTimeMs(System.currentTimeMillis() - beforeParsingTime);
                captureMetadata.setCaptureDurationMs(TimeUnit.MICROSECONDS.toMillis(parsedCapture.getDuration()));
                captureMetadata.setRecordDurationMs(CpuProfilerStage.calculateRecordDurationMs(parsedCapture));
            } else {
                captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.PARSING_FAILURE);
                this.setCapture(null);
            }
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        };
        capture.handleAsync((parsedCapture, exception) -> {
            if (parsedCapture == null) {
                assert (exception != null);
                CpuProfilerStage.getLogger().warn("Unable to parse capture: " + exception.getMessage());
            }
            parsingCallback.accept((CpuCapture)parsedCapture);
            return parsedCapture;
        }, this.getStudioProfilers().getIdeServices().getMainExecutor());
    }

    private static long calculateRecordDurationMs(CpuCapture capture) {
        Range maxDataRange = new Range();
        for (CpuThreadInfo thread : capture.getThreads()) {
            CaptureNode threadMainNode = capture.getCaptureNode(thread.getId());
            assert (threadMainNode != null);
            maxDataRange.expand((double)threadMainNode.getStartGlobal(), (double)threadMainNode.getEndGlobal());
        }
        return TimeUnit.MICROSECONDS.toMillis((long)maxDataRange.getLength());
    }

    private void saveTraceInfo(int traceId, @NotNull CpuCapture capture) {
        long captureFrom = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMin());
        long captureTo = TimeUnit.MICROSECONDS.toNanos((long)capture.getRange().getMax());
        ArrayList<CpuProfiler.Thread> threads = new ArrayList<CpuProfiler.Thread>();
        for (CpuThreadInfo thread : capture.getThreads()) {
            threads.add(CpuProfiler.Thread.newBuilder().setTid(thread.getId()).setName(thread.getName()).build());
        }
        CpuProfiler.TraceInfo traceInfo = CpuProfiler.TraceInfo.newBuilder().setTraceId(traceId).setFromTimestamp(captureFrom).setToTimestamp(captureTo).setProfilerType(this.myActiveConfig.getProfilerType()).addAllThreads(threads).build();
        CpuProfiler.SaveTraceInfoRequest request = CpuProfiler.SaveTraceInfoRequest.newBuilder().setSession(this.getStudioProfilers().getSession()).setProcessId(this.getStudioProfilers().getProcessId()).setTraceInfo(traceInfo).build();
        CpuServiceGrpc.CpuServiceBlockingStub service = this.getStudioProfilers().getClient().getCpuClient();
        service.saveTraceInfo(request);
    }

    private void updateProfilingState() {
        CpuProfiler.ProfilingStateRequest request;
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.ProfilingStateResponse response = cpuService.checkAppProfilingState(request = CpuProfiler.ProfilingStateRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setTimestamp(this.currentTimeNs()).build());
        if (response.getBeingProfiled()) {
            long elapsedTime = response.getCheckTimestamp() - response.getStartTimestamp();
            this.myCaptureStartTimeNs = this.currentTimeNs() - elapsedTime;
            this.myCaptureState = CaptureState.CAPTURING;
            this.myInProgressTraceSeries.clear();
            this.myInProgressTraceSeries.add(TimeUnit.NANOSECONDS.toMicros(this.myCaptureStartTimeNs), (Object)new DefaultDurationData(Long.MAX_VALUE));
            CpuProfiler.CpuProfilingAppStartRequest startRequest = response.getStartRequest();
            this.setActiveConfig(startRequest.getProfilerType(), startRequest.getMode(), startRequest.getBufferSizeInMb(), startRequest.getSamplingIntervalUs());
        } else {
            this.myCaptureStartTimeNs = Long.MAX_VALUE;
            this.myCaptureState = CaptureState.IDLE;
        }
    }

    public void setActiveConfig(CpuProfiler.CpuProfilerType profilerType, CpuProfiler.CpuProfilingAppStartRequest.Mode mode, int bufferSizeLimitMb, int samplingIntervalUs) {
        String anyConfigName = "Current config";
        this.myActiveConfig = new ProfilingConfiguration(anyConfigName, profilerType, mode);
        this.myActiveConfig.setProfilingBufferSizeInMb(bufferSizeLimitMb);
        this.myActiveConfig.setProfilingSamplingIntervalUs(samplingIntervalUs);
    }

    private void selectionChanged() {
        Range range = this.getStudioProfilers().getTimeline().getSelectionRange();
        if (!range.isEmpty()) {
            this.getStudioProfilers().getTimeline().setStreaming(false);
        }
        List infoList = this.getTraceDurations().getSeries().getDataSeries().getDataForXRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (captureRange.getIntersection(range).isEmpty()) continue;
            this.setCapture(((CpuTraceInfo)info.value).getTraceId());
            break;
        }
    }

    private long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getStudioProfilers().getTimeline().getDataRange().getMax()) + TimeUnit.SECONDS.toNanos(0L);
    }

    void setCapture(@Nullable CpuCapture capture) {
        this.myCaptureModel.setCapture(capture);
        this.setProfilerMode(capture == null ? ProfilerMode.NORMAL : ProfilerMode.EXPANDED);
    }

    private void setCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(int traceId) {
        CompletableFuture<CpuCapture> future = this.getCaptureFuture(traceId);
        if (future != null) {
            future.handleAsync((capture, exception) -> {
                this.setAndSelectCapture((CpuCapture)capture);
                return capture;
            }, this.getStudioProfilers().getIdeServices().getMainExecutor());
        }
    }

    public void setAndSelectCapture(@NotNull CpuCapture capture) {
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        boolean wasStreaming = timeline.isStreaming();
        timeline.getSelectionRange().set(capture.getRange());
        timeline.setStreaming(wasStreaming);
        this.setCapture(capture);
    }

    public int getSelectedThread() {
        return this.myCaptureModel.getThread();
    }

    public void setSelectedThread(int id) {
        this.myCaptureModel.setThread(id);
    }

    @NotNull
    public List<ClockType> getClockTypes() {
        return ImmutableList.of((Object)ClockType.GLOBAL, (Object)ClockType.THREAD);
    }

    @NotNull
    public ClockType getClockType() {
        return this.myCaptureModel.getClockType();
    }

    public void setClockType(@NotNull ClockType clockType) {
        this.myCaptureModel.setClockType(clockType);
    }

    @Nullable
    public CpuCapture getCapture() {
        return this.myCaptureModel.getCapture();
    }

    @NotNull
    public CaptureState getCaptureState() {
        return this.myCaptureState;
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        this.myCaptureState = captureState;
        this.myCaptureStartTimeNs = Long.MAX_VALUE;
        this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE);
    }

    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        return this.myProfilingConfiguration;
    }

    public void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myProfilingConfiguration = mode;
        }
        this.myAspect.changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
    }

    @NotNull
    public List<ProfilingConfiguration> getProfilingConfigurations() {
        return this.myProfilingConfigurations;
    }

    public void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            this.updateProfilingConfigurations();
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Profiler.Device selectedDevice = this.getStudioProfilers().getDevice();
        boolean isDeviceAtLeastO = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        this.getStudioProfilers().getIdeServices().openCpuProfilingConfigurationsDialog(this.myProfilingConfiguration, isDeviceAtLeastO, dialogCallback);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    public void updateProfilingConfigurations() {
        boolean selectedDeviceSupportsSimpleperf;
        this.myProfilingConfigurations = new ArrayList<ProfilingConfiguration>();
        this.myProfilingConfigurations.add(EDIT_CONFIGURATIONS_ENTRY);
        this.myProfilingConfigurations.add(CONFIG_SEPARATOR_ENTRY);
        List<ProfilingConfiguration> savedConfigs = this.getStudioProfilers().getIdeServices().getCpuProfilingConfigurations();
        List<ProfilingConfiguration> defaultConfigs = ProfilingConfiguration.getDefaultProfilingConfigurations();
        Profiler.Device selectedDevice = this.getStudioProfilers().getDevice();
        boolean bl = selectedDeviceSupportsSimpleperf = selectedDevice != null && selectedDevice.getFeatureLevel() >= 26;
        if (!selectedDeviceSupportsSimpleperf || !this.getStudioProfilers().getIdeServices().getFeatureConfig().isSimplePerfEnabled()) {
            Predicate<ProfilingConfiguration> simpleperfFilter = pref -> pref.getProfilerType() != CpuProfiler.CpuProfilerType.SIMPLE_PERF;
            savedConfigs = savedConfigs.stream().filter(simpleperfFilter).collect(Collectors.toList());
            defaultConfigs = defaultConfigs.stream().filter(simpleperfFilter).collect(Collectors.toList());
        }
        this.myProfilingConfigurations.addAll(savedConfigs);
        if (!savedConfigs.isEmpty()) {
            this.myProfilingConfigurations.add(CONFIG_SEPARATOR_ENTRY);
        }
        this.myProfilingConfigurations.addAll(defaultConfigs);
        assert (this.myProfilingConfigurations.size() > 2);
        this.myProfilingConfiguration = this.myProfilingConfigurations.get(2);
    }

    @NotNull
    public CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuTraceDataSeries;
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myThreadsStates;
    }

    @Nullable
    public CompletableFuture<CpuCapture> getCaptureFuture(int traceId) {
        CompletableFuture<CpuCapture> capture = this.myCaptureParser.getCapture(traceId);
        if (capture == null) {
            CpuProfiler.GetTraceRequest request = CpuProfiler.GetTraceRequest.newBuilder().setProcessId(this.getStudioProfilers().getProcessId()).setSession(this.getStudioProfilers().getSession()).setTraceId(traceId).build();
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceResponse trace = cpuService.getTrace(request);
            if (trace.getStatus() == CpuProfiler.GetTraceResponse.Status.SUCCESS) {
                capture = this.myCaptureParser.parse(traceId, trace.getData(), trace.getProfilerType());
            }
        }
        return capture;
    }

    public void setCaptureDetails(@Nullable CaptureModel.Details.Type type) {
        this.myCaptureModel.setDetails(type);
    }

    @Nullable
    public CaptureModel.Details getCaptureDetails() {
        return this.myCaptureModel.getDetails();
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    public static class UsageTooltip
    implements Tooltip {
        @NotNull
        private final CpuProfilerStage myStage;
        @NotNull
        private final CpuStageLegends myLegends;

        UsageTooltip(@NotNull CpuProfilerStage stage) {
            this.myStage = stage;
            this.myLegends = new CpuStageLegends(stage.getCpuUsage(), stage.getStudioProfilers().getTimeline().getTooltipRange());
            this.myStage.getStudioProfilers().getUpdater().register((Updatable)this.myLegends);
        }

        @Override
        @NotNull
        public Tooltip.Type getType() {
            return Tooltip.Type.USAGE;
        }

        @Override
        public void dispose() {
            this.myStage.getStudioProfilers().getUpdater().unregister((Updatable)this.myLegends);
        }

        @NotNull
        public CpuStageLegends getLegends() {
            return this.myLegends;
        }
    }

    public static class ThreadsTooltip
    extends AspectModel<Aspect>
    implements Tooltip {
        @NotNull
        private final CpuProfilerStage myStage;
        @Nullable
        private String myThreadName;
        @Nullable
        private ThreadStateDataSeries mySeries;
        @Nullable
        private ThreadState myThreadState;

        ThreadsTooltip(@NotNull CpuProfilerStage stage) {
            this.myStage = stage;
            Range tooltipRange = stage.getStudioProfilers().getTimeline().getTooltipRange();
            tooltipRange.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateThreadState);
        }

        private void updateThreadState() {
            this.myThreadState = null;
            if (this.mySeries == null) {
                this.changed(Aspect.THREAD_STATE);
                return;
            }
            Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
            List<SeriesData<ThreadState>> series = this.mySeries.getDataForXRange(this.myStage.getStudioProfilers().getTimeline().getViewRange());
            for (int i = 0; i < series.size(); ++i) {
                if (i + 1 != series.size() && !(tooltipRange.getMin() < (double)series.get((int)(i + 1)).x)) continue;
                this.myThreadState = (ThreadState)((Object)series.get((int)i).value);
                break;
            }
            this.changed(Aspect.THREAD_STATE);
        }

        @Override
        @NotNull
        public Tooltip.Type getType() {
            return Tooltip.Type.THREADS;
        }

        void setThread(@Nullable String threadName, @Nullable ThreadStateDataSeries stateSeries) {
            this.myThreadName = threadName;
            this.mySeries = stateSeries;
            this.updateThreadState();
        }

        @Nullable
        public String getThreadName() {
            return this.myThreadName;
        }

        @Nullable
        ThreadState getThreadState() {
            return this.myThreadState;
        }

        public static enum Aspect {
            THREAD_STATE;

        }
    }

    public static interface Tooltip {
        @NotNull
        public Type getType();

        default public void dispose() {
        }

        public static enum Type {
            USAGE(UsageTooltip::new),
            THREADS(ThreadsTooltip::new);

            @NotNull
            private final Function<CpuProfilerStage, Tooltip> myBuilder;

            private Type(Function<CpuProfilerStage, Tooltip> builder) {
                this.myBuilder = builder;
            }

            public Tooltip build(@NotNull CpuProfilerStage stage) {
                return this.myBuilder.apply(stage);
            }
        }
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            super(100);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            return this.myOthersLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            return this.myThreadsLegend;
        }
    }

    @VisibleForTesting
    class CpuTraceDataSeries
    implements DataSeries<CpuTraceInfo> {
        CpuTraceDataSeries() {
        }

        public List<SeriesData<CpuTraceInfo>> getDataForXRange(Range xRange) {
            long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
            long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
            CpuServiceGrpc.CpuServiceBlockingStub cpuService = CpuProfilerStage.this.getStudioProfilers().getClient().getCpuClient();
            CpuProfiler.GetTraceInfoResponse response = cpuService.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setProcessId(CpuProfilerStage.this.getStudioProfilers().getProcessId()).setSession(CpuProfilerStage.this.getStudioProfilers().getSession()).setFromTimestamp(rangeMin).setToTimestamp(rangeMax).build());
            ArrayList<SeriesData<CpuTraceInfo>> seriesData = new ArrayList<SeriesData<CpuTraceInfo>>();
            for (CpuProfiler.TraceInfo protoTraceInfo : response.getTraceInfoList()) {
                CpuTraceInfo info = new CpuTraceInfo(protoTraceInfo);
                seriesData.add((SeriesData<CpuTraceInfo>)new SeriesData((long)info.getRange().getMin(), (Object)info));
            }
            return seriesData;
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.myCaptureState == CaptureState.CAPTURING) {
                CpuProfilerStage.this.myAspect.changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        PARSING,
        STARTING,
        STOPPING;

    }

    public static enum ThreadState {
        RUNNING,
        RUNNING_CAPTURED,
        SLEEPING,
        SLEEPING_CAPTURED,
        DEAD,
        DEAD_CAPTURED,
        WAITING,
        WAITING_CAPTURED,
        UNKNOWN;

    }
}

