/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.ConfigurableDurationData;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.CpuProfiler;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuTraceInfo
implements ConfigurableDurationData {
    private final int myTraceId;
    @NotNull
    private final Range myRange;

    public CpuTraceInfo(CpuProfiler.TraceInfo traceInfo) {
        this.myTraceId = traceInfo.getTraceId();
        this.myRange = new Range((double)TimeUnit.NANOSECONDS.toMicros(traceInfo.getFromTimestamp()), (double)TimeUnit.NANOSECONDS.toMicros(traceInfo.getToTimestamp()));
    }

    public long getDuration() {
        return (long)this.myRange.getLength();
    }

    @NotNull
    public Range getRange() {
        return this.myRange;
    }

    public int getTraceId() {
        return this.myTraceId;
    }

    public boolean getSelectableWhenMaxDuration() {
        return false;
    }

    public boolean canSelectPartialRange() {
        return true;
    }
}

