/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CpuTreeNode;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

abstract class CpuTreeModel<T extends CpuTreeNode<T>>
extends DefaultTreeModel {
    private final Range myRange;
    private final Range myCurrentRange;
    private final AspectObserver myAspectObserver;

    public CpuTreeModel(@NotNull Range range, @NotNull T node) {
        super(new DefaultMutableTreeNode(node));
        this.myRange = range;
        this.myCurrentRange = new Range();
        this.myAspectObserver = new AspectObserver();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
    }

    public void rangeChanged() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        LinkedList<Range> diffs = new LinkedList<Range>();
        diffs.addAll(this.myRange.subtract(this.myCurrentRange));
        diffs.addAll(this.myCurrentRange.subtract(this.myRange));
        this.update(root, this.myRange, diffs);
        this.myCurrentRange.set(this.myRange);
    }

    public boolean changes(T data, List<Range> ranges) {
        for (Range diff : ranges) {
            if (!((CpuTreeNode)data).inRange(diff)) continue;
            return true;
        }
        return false;
    }

    private void update(DefaultMutableTreeNode node, Range range, List<Range> ranges) {
        CpuTreeNode data = (CpuTreeNode)node.getUserObject();
        if (this.changes(data, ranges)) {
            Enumeration<TreeNode> e = node.children();
            HashMap<CpuTreeNode, DefaultMutableTreeNode> children = new HashMap<CpuTreeNode, DefaultMutableTreeNode>();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                children.put((CpuTreeNode)child.getUserObject(), child);
            }
            HashSet<CpuTreeNode> actual = new HashSet<CpuTreeNode>();
            for (CpuTreeNode cpuTreeNode : data.getChildren()) {
                if (cpuTreeNode.inRange(range)) {
                    actual.add(cpuTreeNode);
                    DefaultMutableTreeNode existing = (DefaultMutableTreeNode)children.get(cpuTreeNode);
                    if (existing == null) {
                        existing = new DefaultMutableTreeNode(cpuTreeNode);
                        this.insertNodeInto(existing, node, node.getChildCount());
                    }
                    this.update(existing, range, ranges);
                    continue;
                }
                cpuTreeNode.reset();
            }
            for (Map.Entry entry : children.entrySet()) {
                if (actual.contains(entry.getKey())) continue;
                this.removeNodeFromParent((MutableTreeNode)entry.getValue());
            }
            data.update(range);
            this.nodeChanged(node);
        }
    }

    @NotNull
    protected Range getRange() {
        return this.myRange;
    }

    public boolean isEmpty() {
        CpuTreeNode data = (CpuTreeNode)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
        return data.getTotal() == 0.0;
    }

    abstract void expand(@NotNull DefaultMutableTreeNode var1);
}

