/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.MethodModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CpuTreeNode<T extends CpuTreeNode> {
    protected final List<CaptureNode> myNodes = new ArrayList<CaptureNode>();
    private final List<T> myChildren = new ArrayList<T>();
    private final String myId;
    protected double myTotal = 0.0;
    protected double myChildrenTotal = 0.0;

    public CpuTreeNode(String id) {
        this.myId = id;
    }

    public String getId() {
        return this.myId;
    }

    protected void addNode(@NotNull CaptureNode node) {
        this.myNodes.add(node);
    }

    protected void addNodes(@NotNull List<CaptureNode> nodes) {
        nodes.forEach(this::addNode);
    }

    @NotNull
    public List<CaptureNode> getNodes() {
        return this.myNodes;
    }

    protected void addChild(@NotNull T child) {
        this.myChildren.add(child);
    }

    protected List<T> getChildren() {
        return this.myChildren;
    }

    public double getTotal() {
        return this.myTotal;
    }

    public double getChildrenTotal() {
        return this.myChildrenTotal;
    }

    public double getSelf() {
        return this.getTotal() - this.getChildrenTotal();
    }

    public void update(@NotNull Range range) {
        this.myTotal = 0.0;
        this.myChildrenTotal = 0.0;
        for (CaptureNode node : this.myNodes) {
            this.myTotal += CpuTreeNode.getIntersection(range, node);
            for (HNode hNode : node.getChildren()) {
                this.myChildrenTotal += CpuTreeNode.getIntersection(range, (HNode<MethodModel>)hNode);
            }
        }
    }

    protected static double getIntersection(@NotNull Range range, @NotNull HNode<MethodModel> node) {
        Range intersection = range.getIntersection(new Range((double)node.getStart(), (double)node.getEnd()));
        return intersection.isEmpty() ? 0.0 : intersection.getLength();
    }

    public boolean inRange(Range range) {
        return this.myNodes.stream().anyMatch(node -> (double)node.getStart() < range.getMax() && range.getMin() < (double)node.getEnd());
    }

    public void reset() {
        this.myTotal = 0.0;
        this.myChildrenTotal = 0.0;
    }

    public abstract String getMethodName();

    public abstract String getClassName();

    public abstract String getSignature();
}

