/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuUsageDataSeries
implements DataSeries<Long> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    private boolean myOtherProcesses;
    private final int myProcessId;
    private final Common.Session mySession;

    public CpuUsageDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, boolean otherProcesses, int id, Common.Session session) {
        this.myClient = client;
        this.myOtherProcesses = otherProcesses;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        CpuProfiler.CpuDataRequest.Builder dataRequestBuilder = CpuProfiler.CpuDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        CpuProfiler.CpuDataResponse response = this.myClient.getData(dataRequestBuilder.build());
        CpuProfiler.CpuProfilerData lastCpuData = null;
        for (CpuProfiler.CpuProfilerData data : response.getDataList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(data.getBasicInfo().getEndTimestamp());
            if (lastCpuData == null) {
                lastCpuData = data;
                continue;
            }
            CpuUsageData usageData = CpuUsageDataSeries.getCpuUsageData(data, lastCpuData);
            if (this.myOtherProcesses) {
                seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)((long)usageData.getOtherProcessesUsage())));
            } else {
                seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)((long)usageData.getAppUsage())));
            }
            lastCpuData = data;
        }
        return seriesData;
    }

    private static CpuUsageData getCpuUsageData(CpuProfiler.CpuProfilerData data, CpuProfiler.CpuProfilerData lastData) {
        long elapsed = data.getCpuUsage().getElapsedTimeInMillisec() - lastData.getCpuUsage().getElapsedTimeInMillisec();
        double app = 100.0 * (double)(data.getCpuUsage().getAppCpuTimeInMillisec() - lastData.getCpuUsage().getAppCpuTimeInMillisec()) / (double)elapsed;
        double system = 100.0 * (double)(data.getCpuUsage().getSystemCpuTimeInMillisec() - lastData.getCpuUsage().getSystemCpuTimeInMillisec()) / (double)elapsed;
        system = Math.max(0.0, Math.min(system, 100.0));
        app = Math.max(0.0, Math.min(app, system));
        return new CpuUsageData(app, system);
    }

    private static final class CpuUsageData {
        private double myAppUsage;
        private double mySystemUsage;

        CpuUsageData(double appUsage, double systemUsage) {
            this.myAppUsage = appUsage;
            this.mySystemUsage = systemUsage;
        }

        double getAppUsage() {
            return this.myAppUsage;
        }

        double getOtherProcessesUsage() {
            return this.mySystemUsage - this.myAppUsage;
        }
    }
}

