/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuThreadCountDataSeries;
import com.android.tools.profilers.cpu.CpuUsage;
import com.android.tools.profilers.cpu.CpuUsageDataSeries;
import org.jetbrains.annotations.NotNull;

public class DetailedCpuUsage
extends CpuUsage {
    @NotNull
    private final RangedContinuousSeries myOtherCpuSeries;
    @NotNull
    private final RangedContinuousSeries myThreadsCountSeries;
    @NotNull
    private final Range myThreadRange = new Range(0.0, 8.0);

    public DetailedCpuUsage(@NotNull StudioProfilers profilers) {
        super(profilers);
        CpuUsageDataSeries others = new CpuUsageDataSeries(profilers.getClient().getCpuClient(), true, profilers.getProcessId(), profilers.getSession());
        this.myOtherCpuSeries = new RangedContinuousSeries("Others", profilers.getTimeline().getViewRange(), this.getCpuRange(), (DataSeries)others);
        CpuThreadCountDataSeries threads = new CpuThreadCountDataSeries(profilers.getClient().getCpuClient(), profilers.getProcessId(), profilers.getSession());
        this.myThreadsCountSeries = new RangedContinuousSeries("Threads", profilers.getTimeline().getViewRange(), this.myThreadRange, (DataSeries)threads);
        this.add(this.myOtherCpuSeries);
        this.add(this.myThreadsCountSeries);
    }

    @NotNull
    public RangedContinuousSeries getOtherCpuSeries() {
        return this.myOtherCpuSeries;
    }

    @NotNull
    public RangedContinuousSeries getThreadsCountSeries() {
        return this.myThreadsCountSeries;
    }

    @NotNull
    public Range getThreadRange() {
        return this.myThreadRange;
    }

    @Override
    protected String getCpuSeriesLabel() {
        return "App";
    }
}

