/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MethodModel {
    @NotNull
    private final String myClassName;
    @NotNull
    private final String myName;
    @NotNull
    private final String mySignature;

    public MethodModel(@NotNull String name, @NotNull String className, @NotNull String signature) {
        this.myName = name;
        this.myClassName = className;
        this.mySignature = signature;
    }

    public MethodModel(String name) {
        this(name, "", "");
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public String getSignature() {
        return this.mySignature;
    }

    public String getId() {
        String separator = StringUtil.isEmpty((String)this.myClassName) ? "" : ".";
        return String.format("%s%s%s%s", this.myClassName, separator, this.myName, this.mySignature);
    }
}

