/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class ThreadStateDataSeries
implements DataSeries<CpuProfilerStage.ThreadState> {
    private final int myProcessId;
    private final Common.Session myDeviceSerial;
    private final int myThreadId;
    private final CpuProfilerStage myStage;

    public ThreadStateDataSeries(@NotNull CpuProfilerStage stage, int pid, Common.Session session, int tid) {
        this.myStage = stage;
        this.myProcessId = pid;
        this.myDeviceSerial = session;
        this.myThreadId = tid;
    }

    public int getProcessId() {
        return this.myProcessId;
    }

    public List<SeriesData<CpuProfilerStage.ThreadState>> getDataForXRange(Range xRange) {
        ArrayList<SeriesData<CpuProfilerStage.ThreadState>> data = new ArrayList<SeriesData<CpuProfilerStage.ThreadState>>();
        long min = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
        long max = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myStage.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.GetThreadsResponse threads = client.getThreads(CpuProfiler.GetThreadsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.myDeviceSerial).setStartTimestamp(min).setEndTimestamp(max).build());
        CpuProfiler.GetTraceInfoResponse traces = client.getTraceInfo(CpuProfiler.GetTraceInfoRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.myDeviceSerial).setFromTimestamp(min).setToTimestamp(max).build());
        for (CpuProfiler.GetThreadsResponse.Thread thread : threads.getThreadsList()) {
            if (thread.getTid() != this.myThreadId) continue;
            ArrayList<Double> captureTimes = new ArrayList<Double>(traces.getTraceInfoCount() * 2);
            for (CpuProfiler.TraceInfo traceInfo : traces.getTraceInfoList()) {
                if (!traceInfo.getThreadsList().stream().anyMatch(t -> t.getTid() == this.myThreadId)) continue;
                captureTimes.add(Double.valueOf(TimeUnit.NANOSECONDS.toMicros(traceInfo.getFromTimestamp())));
                captureTimes.add(Double.valueOf(TimeUnit.NANOSECONDS.toMicros(traceInfo.getToTimestamp())));
            }
            List list = thread.getActivitiesList();
            int i = 0;
            int j = 0;
            boolean inCapture = false;
            CpuProfiler.GetThreadsResponse.State state = CpuProfiler.GetThreadsResponse.State.UNSPECIFIED;
            while (i < list.size()) {
                long time;
                long captureTime;
                CpuProfiler.GetThreadsResponse.ThreadActivity activity = (CpuProfiler.GetThreadsResponse.ThreadActivity)list.get(i);
                long timestamp = TimeUnit.NANOSECONDS.toMicros(activity.getTimestamp());
                long l = captureTime = j < captureTimes.size() ? ((Double)captureTimes.get(j)).longValue() : Long.MAX_VALUE;
                if (captureTime < timestamp) {
                    inCapture = !inCapture;
                    time = captureTime;
                    ++j;
                } else {
                    state = activity.getNewState();
                    time = timestamp;
                    ++i;
                }
                if (state == CpuProfiler.GetThreadsResponse.State.UNSPECIFIED) continue;
                data.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(time, (Object)ThreadStateDataSeries.getState(state, inCapture)));
            }
            while (j < captureTimes.size()) {
                inCapture = !inCapture;
                data.add((SeriesData<CpuProfilerStage.ThreadState>)new SeriesData(((Double)captureTimes.get(j)).longValue(), (Object)ThreadStateDataSeries.getState(state, inCapture)));
                ++j;
            }
        }
        return data;
    }

    private static CpuProfilerStage.ThreadState getState(CpuProfiler.GetThreadsResponse.State state, boolean captured) {
        switch (state) {
            case RUNNING: {
                return captured ? CpuProfilerStage.ThreadState.RUNNING_CAPTURED : CpuProfilerStage.ThreadState.RUNNING;
            }
            case DEAD: {
                return captured ? CpuProfilerStage.ThreadState.DEAD_CAPTURED : CpuProfilerStage.ThreadState.DEAD;
            }
            case SLEEPING: {
                return captured ? CpuProfilerStage.ThreadState.SLEEPING_CAPTURED : CpuProfilerStage.ThreadState.SLEEPING;
            }
            case WAITING: {
                return captured ? CpuProfilerStage.ThreadState.WAITING_CAPTURED : CpuProfilerStage.ThreadState.WAITING;
            }
        }
        return CpuProfilerStage.ThreadState.UNKNOWN;
    }

    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(ThreadStateDataSeries.class);
    }
}

