/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuTreeNode;
import com.android.tools.profilers.cpu.MethodModel;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

class TopDownNode
extends CpuTreeNode<TopDownNode> {
    private static final String INVALID_ID = "";

    public TopDownNode(@NotNull CaptureNode node) {
        super(node.getData() == null ? INVALID_ID : node.getData().getId());
        this.addNode(node);
        TreeMap<String, TopDownNode> children = new TreeMap<String, TopDownNode>();
        for (CaptureNode child : node.getChildren()) {
            assert (child.getData() != null);
            TopDownNode prev = (TopDownNode)children.get(child.getData().getId());
            TopDownNode other = new TopDownNode(child);
            if (prev == null) {
                children.put(child.getData().getId(), other);
                this.addChild(other);
                continue;
            }
            prev.merge(other);
        }
    }

    private void merge(TopDownNode other) {
        this.addNodes(other.getNodes());
        TreeMap<String, TopDownNode> children = new TreeMap<String, TopDownNode>();
        for (TopDownNode child : this.getChildren()) {
            children.put(child.getId(), child);
        }
        for (TopDownNode otherChild : other.getChildren()) {
            TopDownNode existing = (TopDownNode)children.get(otherChild.getId());
            if (existing != null) {
                existing.merge(otherChild);
                continue;
            }
            this.addChild(otherChild);
        }
    }

    @Override
    public String getMethodName() {
        MethodModel data = this.getNodes().get(0).getData();
        return data == null ? INVALID_ID : data.getName();
    }

    @Override
    public String getClassName() {
        MethodModel data = this.getNodes().get(0).getData();
        return data == null ? INVALID_ID : data.getClassName();
    }

    @Override
    public String getSignature() {
        MethodModel data = this.getNodes().get(0).getData();
        return data == null ? INVALID_ID : data.getSignature();
    }
}

