/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.ActivityAction;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.StackedEventType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profilers.ProfilerClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ActivityEventDataSeries
implements DataSeries<EventAction<StackedEventType>> {
    @NotNull
    private ProfilerClient myClient;
    private final int myProcessId;
    private final Common.Session mySession;
    private final boolean myFragmentsOnly;

    public ActivityEventDataSeries(@NotNull ProfilerClient client, int id, Common.Session session) {
        this(client, id, session, false);
    }

    public ActivityEventDataSeries(@NotNull ProfilerClient client, int id, Common.Session session, boolean fragmentOnly) {
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
        this.myFragmentsOnly = fragmentOnly;
    }

    public List<SeriesData<EventAction<StackedEventType>>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        ArrayList<SeriesData<EventAction<StackedEventType>>> seriesData = new ArrayList<SeriesData<EventAction<StackedEventType>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myClient.getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()));
        EventProfiler.ActivityDataResponse response = eventService.getActivityData(dataRequestBuilder.build());
        for (EventProfiler.ActivityData data : response.getDataList()) {
            boolean isFragment;
            long actionStart = 0L;
            long actionEnd = 0L;
            boolean bl = isFragment = !data.getFragmentData().equals((Object)EventProfiler.FragmentData.getDefaultInstance());
            if (this.myFragmentsOnly != isFragment) continue;
            boolean haveEvent = false;
            for (int i = 0; i < data.getStateChangesCount(); ++i) {
                EventProfiler.ActivityStateData state = data.getStateChanges(i);
                StackedEventType action = StackedEventType.NONE;
                String displayString = data.getName();
                switch (state.getState()) {
                    case ADDED: 
                    case RESUMED: {
                        action = StackedEventType.ACTIVITY_STARTED;
                        actionStart = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        break;
                    }
                    case DESTROYED: {
                        if (i != data.getStateChangesCount() - 1) break;
                        displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                    }
                    case REMOVED: 
                    case PAUSED: {
                        action = StackedEventType.ACTIVITY_COMPLETED;
                        actionEnd = TimeUnit.NANOSECONDS.toMicros(state.getTimestamp());
                        haveEvent = true;
                        break;
                    }
                }
                while (haveEvent && ++i < data.getStateChangesCount()) {
                    state = data.getStateChanges(i);
                    EventProfiler.ActivityStateData.ActivityState activityState = state.getState();
                    if (this.getComponentInStartingOrRunningState(activityState)) {
                        --i;
                        break;
                    }
                    displayString = String.format("%s - %s", displayString, state.getState().toString().toLowerCase());
                }
                if (!haveEvent && (i != data.getStateChangesCount() - 1 || action == StackedEventType.NONE)) continue;
                seriesData.add((SeriesData<EventAction<StackedEventType>>)new SeriesData(actionStart, (Object)new ActivityAction(actionStart, actionEnd, action, displayString, data.getHash(), data.getFragmentData().getActivityContextHash())));
                actionEnd = 0L;
                actionStart = 0L;
                haveEvent = false;
            }
        }
        return seriesData;
    }

    private boolean getComponentInStartingOrRunningState(EventProfiler.ActivityStateData.ActivityState state) {
        switch (state) {
            case ADDED: 
            case RESUMED: 
            case ATTACHED: 
            case CREATED: 
            case CREATEDVIEW: 
            case ACTIVITYCREATED: 
            case STARTED: {
                return true;
            }
        }
        return false;
    }
}

