/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.adtui.model.event.StackedEventType;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.ActivityEventDataSeries;
import com.android.tools.profilers.event.SimpleEventDataSeries;
import org.jetbrains.annotations.NotNull;

public class EventMonitor
extends ProfilerMonitor {
    @NotNull
    private final EventModel<SimpleEventType> mySimpleEvents;
    @NotNull
    private final EventModel<StackedEventType> myActivityEvents;
    @NotNull
    private final EventModel<StackedEventType> myFragmentEvents;
    private boolean myEnabled;

    public EventMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        SimpleEventDataSeries events = new SimpleEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getProcessId(), this.myProfilers.getSession());
        this.mySimpleEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)events));
        ActivityEventDataSeries activities = new ActivityEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getProcessId(), this.myProfilers.getSession(), false);
        this.myActivityEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)activities));
        ActivityEventDataSeries fragments = new ActivityEventDataSeries(this.myProfilers.getClient(), this.myProfilers.getProcessId(), this.myProfilers.getSession(), true);
        this.myFragmentEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)fragments));
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::onAgentStatusChanged);
        this.onAgentStatusChanged();
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register(this.mySimpleEvents);
        this.myProfilers.getUpdater().register(this.myActivityEvents);
        this.myProfilers.getUpdater().register(this.myFragmentEvents);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister(this.mySimpleEvents);
        this.myProfilers.getUpdater().unregister(this.myActivityEvents);
        this.myProfilers.getUpdater().unregister(this.myFragmentEvents);
    }

    @NotNull
    public EventModel<SimpleEventType> getSimpleEvents() {
        return this.mySimpleEvents;
    }

    @NotNull
    public EventModel<StackedEventType> getActivityEvents() {
        return this.myActivityEvents;
    }

    @NotNull
    public EventModel<StackedEventType> getFragmentEvents() {
        return this.myFragmentEvents;
    }

    @Override
    public String getName() {
        return "EVENTS";
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void onAgentStatusChanged() {
        boolean agentAttached = this.myProfilers.isAgentAttached();
        if (this.myEnabled != agentAttached) {
            this.myEnabled = agentAttached;
            this.changed(ProfilerMonitor.Aspect.ENABLE);
        }
    }
}

