/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.android.tools.adtui.model.event.KeyboardData;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profilers.ProfilerClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleEventDataSeries
implements DataSeries<EventAction<SimpleEventType>> {
    @NotNull
    private ProfilerClient myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public SimpleEventDataSeries(@NotNull ProfilerClient client, int id, Common.Session session) {
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<EventAction<SimpleEventType>>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        ArrayList<SeriesData<EventAction<SimpleEventType>>> seriesData = new ArrayList<SeriesData<EventAction<SimpleEventType>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myClient.getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()));
        EventProfiler.SystemDataResponse response = eventService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : response.getDataList()) {
            long actionStart = TimeUnit.NANOSECONDS.toMicros(data.getStartTimestamp());
            long actionEnd = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            switch (data.getType()) {
                case ROTATION: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)SimpleEventType.ROTATION)));
                    break;
                }
                case UNSPECIFIED: {
                    break;
                }
                case TOUCH: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)SimpleEventType.TOUCH)));
                    break;
                }
                case KEY: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new KeyboardAction(actionStart, actionEnd, new KeyboardData(data.getEventData()))));
                    break;
                }
            }
        }
        return seriesData;
    }
}

