/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class AllocStatsDataSeries
implements DataSeries<Long> {
    @NotNull
    private MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;
    @NotNull
    private Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> myFilter;

    public AllocStatsDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, int id, Common.Session session, @NotNull Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> filter) {
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
        this.myFilter = filter;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : response.getAllocStatsSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)this.myFilter.apply(sample)));
        }
        return seriesData;
    }
}

