/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.Comparator;
import java.util.function.Supplier;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class AttributeColumn<T extends MemoryObject> {
    private final String myName;
    private final Supplier<ColoredTreeCellRenderer> myRendererSuppier;
    private final int myHeaderAlignment;
    private final int myPreferredWidth;
    private final Comparator<MemoryObjectTreeNode<T>> myComparator;

    public AttributeColumn(@NotNull String name, @NotNull Supplier<ColoredTreeCellRenderer> rendererSupplier, int headerAlignment, int preferredWidth, @NotNull Comparator<MemoryObjectTreeNode<T>> comparator) {
        this.myName = name;
        this.myRendererSuppier = rendererSupplier;
        this.myHeaderAlignment = headerAlignment;
        this.myPreferredWidth = preferredWidth;
        this.myComparator = comparator;
    }

    @NotNull
    public ColumnTreeBuilder.ColumnBuilder getBuilder() {
        Border border = this.myHeaderAlignment == 2 ? ProfilerLayout.TABLE_COLUMN_HEADER_BORDER : ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER;
        return new ColumnTreeBuilder.ColumnBuilder().setName(this.myName).setRenderer(this.myRendererSuppier.get()).setHeaderAlignment(this.myHeaderAlignment).setPreferredWidth(this.myPreferredWidth).setComparator(this.myComparator).setHeaderBorder(border);
    }

    public Comparator<MemoryObjectTreeNode<T>> getComparator() {
        return this.myComparator;
    }
}

