/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.RelativeTimeConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CaptureDataSeries<T extends CaptureObject>
implements DataSeries<CaptureDurationData<T>> {
    @NotNull
    protected final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @Nullable
    protected final Common.Session mySession;
    protected final int myProcessId;
    @NotNull
    protected final RelativeTimeConverter myConverter;
    @NotNull
    protected final FeatureTracker myFeatureTracker;

    protected CaptureDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @Nullable Common.Session session, int processId, @NotNull RelativeTimeConverter converter, @NotNull FeatureTracker featureTracker) {
        this.myClient = client;
        this.myProcessId = processId;
        this.myConverter = converter;
        this.mySession = session;
        this.myFeatureTracker = featureTracker;
    }

    public static long getHostTime(long time) {
        return TimeUnit.NANOSECONDS.toMicros(time);
    }

    public static long getDurationUs(long startTimeNs, long endTimeNs) {
        return endTimeNs == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.NANOSECONDS.toMicros(endTimeNs - startTimeNs);
    }
}

