/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.AllocStatsDataSeries;
import com.android.tools.profilers.memory.MemoryUsage;
import org.jetbrains.annotations.NotNull;

public class DetailedMemoryUsage
extends MemoryUsage {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Range myObjectsRange;
    @NotNull
    private final RangedContinuousSeries myJavaSeries;
    @NotNull
    private final RangedContinuousSeries myNativeSeries;
    @NotNull
    private final RangedContinuousSeries myGraphicsSeries;
    @NotNull
    private final RangedContinuousSeries myStackSeries;
    @NotNull
    private final RangedContinuousSeries myCodeSeries;
    @NotNull
    private final RangedContinuousSeries myOtherSeries;
    @NotNull
    private final RangedContinuousSeries myObjectsSeries;

    public DetailedMemoryUsage(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myProfilers = profilers;
        this.myObjectsRange = new Range(0.0, 0.0);
        this.myJavaSeries = this.createRangedSeries(profilers, "Java", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getJavaMem);
        this.myNativeSeries = this.createRangedSeries(profilers, "Native", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getNativeMem);
        this.myGraphicsSeries = this.createRangedSeries(profilers, "Graphics", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getGraphicsMem);
        this.myStackSeries = this.createRangedSeries(profilers, "Stack", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getStackMem);
        this.myCodeSeries = this.createRangedSeries(profilers, "Code", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getCodeMem);
        this.myOtherSeries = this.createRangedSeries(profilers, "Others", this.getMemoryRange(), MemoryProfiler.MemoryData.MemorySample::getOthersMem);
        MemoryServiceGrpc.MemoryServiceBlockingStub client = profilers.getClient().getMemoryClient();
        AllocStatsDataSeries series = new AllocStatsDataSeries(client, profilers.getProcessId(), profilers.getSession(), sample -> sample.getJavaAllocationCount() - sample.getJavaFreeCount());
        this.myObjectsSeries = new RangedContinuousSeries("Allocated", profilers.getTimeline().getViewRange(), this.getObjectsRange(), (DataSeries)series);
        this.add(this.myJavaSeries);
        this.add(this.myNativeSeries);
        this.add(this.myGraphicsSeries);
        this.add(this.myStackSeries);
        this.add(this.myCodeSeries);
        this.add(this.myOtherSeries);
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    @NotNull
    public Range getObjectsRange() {
        return this.myObjectsRange;
    }

    @NotNull
    public RangedContinuousSeries getJavaSeries() {
        return this.myJavaSeries;
    }

    @NotNull
    public RangedContinuousSeries getNativeSeries() {
        return this.myNativeSeries;
    }

    @NotNull
    public RangedContinuousSeries getGraphicsSeries() {
        return this.myGraphicsSeries;
    }

    @NotNull
    public RangedContinuousSeries getStackSeries() {
        return this.myStackSeries;
    }

    @NotNull
    public RangedContinuousSeries getCodeSeries() {
        return this.myCodeSeries;
    }

    @NotNull
    public RangedContinuousSeries getOtherSeries() {
        return this.myOtherSeries;
    }

    @NotNull
    public RangedContinuousSeries getObjectsSeries() {
        return this.myObjectsSeries;
    }

    @Override
    protected String getTotalSeriesLabel() {
        return "Total";
    }

    private void agentStatusChanged() {
        if (this.myProfilers.isAgentAttached()) {
            this.add(this.myObjectsSeries);
        } else {
            this.remove(this.myObjectsSeries);
        }
    }
}

