/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.flat.FlatButton;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryCaptureView
extends AspectObserver {
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JButton myExportButton;
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private CaptureObject myCaptureObject = null;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryCaptureView.class);
    }

    MemoryCaptureView(@NotNull MemoryProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.myStage = stage;
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::reset).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::refresh);
        this.myPanel = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        this.myLabel = new JLabel();
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.myExportButton = new FlatButton(AllIcons.Actions.Export);
        this.myExportButton.setToolTipText("Export capture to file");
        this.myExportButton.addActionListener(e -> ideProfilerComponents.openExportDialog(() -> "Export As", this::getFileExtension, file -> stage.getStudioProfilers().getIdeServices().saveFile((File)file, this::saveToFile, null)));
        this.reset();
    }

    @VisibleForTesting
    @NotNull
    JLabel getLabel() {
        return this.myLabel;
    }

    @NotNull
    JComponent getComponent() {
        return this.myPanel;
    }

    private void reset() {
        this.myPanel.removeAll();
        this.myLabel.setText("");
        this.myCaptureObject = this.myStage.getSelectedCapture();
        this.myExportButton.setEnabled(false);
    }

    private void refresh() {
        boolean validCapture;
        CaptureObject captureObject = this.myStage.getSelectedCapture();
        boolean bl = validCapture = captureObject == this.myCaptureObject && this.myCaptureObject != null;
        if (validCapture) {
            if (captureObject.isExportable()) {
                this.myExportButton.setEnabled(captureObject.isExportable());
                this.myPanel.add(this.myExportButton);
                this.myPanel.add((Component)new FlatSeparator());
            }
            this.myLabel.setText(this.myCaptureObject.getName());
            this.myPanel.add(this.myLabel);
            this.myPanel.add((Component)new FlatSeparator());
        }
    }

    @Nullable
    private String getFileExtension() {
        return this.myCaptureObject == null ? null : this.myCaptureObject.getExportableExtension();
    }

    private void saveToFile(@NotNull FileOutputStream outputStream) {
        if (this.myCaptureObject != null) {
            try {
                this.myCaptureObject.saveToFile(outputStream);
            }
            catch (IOException e) {
                MemoryCaptureView.getLogger().warn((Throwable)e);
            }
        }
    }
}

