/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.AttributeColumn;
import com.android.tools.profilers.memory.LazyMemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.SimpleColumnRenderer;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MethodSet;
import com.android.tools.profilers.memory.adapters.PackageSet;
import com.android.tools.profilers.memory.adapters.ThreadSet;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MemoryClassifierView
extends AspectObserver {
    private static final int LABEL_COLUMN_WIDTH = 800;
    private static final int DEFAULT_COLUMN_WIDTH = 80;
    private static final int HEAP_UPDATING_DELAY_MS = 250;
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final Map<CaptureObject.ClassifierAttribute, AttributeColumn<ClassifierSet>> myAttributeColumns = new HashMap<CaptureObject.ClassifierAttribute, AttributeColumn<ClassifierSet>>();
    @Nullable
    private CaptureObject myCaptureObject = null;
    @Nullable
    private HeapSet myHeapSet = null;
    @Nullable
    private ClassSet myClassSet = null;
    @Nullable
    private ClassifierSet myClassifierSet = null;
    @NotNull
    private final JPanel myPanel = new JPanel(new BorderLayout());
    @NotNull
    private final LoadingPanel myLoadingPanel;
    @Nullable
    private JComponent myColumnTree;
    @Nullable
    private JTree myTree;
    @Nullable
    private DefaultTreeModel myTreeModel;
    @Nullable
    private TableColumnModel myTableColumnModel;
    @Nullable
    private MemoryClassifierTreeNode myTreeRoot;
    @Nullable
    private Comparator<MemoryObjectTreeNode<ClassifierSet>> myInitialComparator;

    public MemoryClassifierView(@NotNull MemoryProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        this.myStage = stage;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myLoadingPanel = this.myIdeProfilerComponents.createLoadingPanel(250);
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::loadCapture).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::refreshCapture).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP, this::refreshHeapSet).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING, this::startHeapLoadingUi).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED, this::stopHeapLoadingUi).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP_CONTENTS, this::refreshTree).onChange((Enum)MemoryProfilerAspect.CURRENT_CLASS, this::refreshClassSet).onChange((Enum)MemoryProfilerAspect.CLASS_GROUPING, this::refreshGrouping);
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.LABEL, new AttributeColumn("Class Name", this::getNameColumnRenderer, 2, 800, MemoryClassifierView.createTreeNodeComparator(Comparator.comparing(ClassifierSet::getName), Comparator.comparing(ClassifierSet::getName))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.ALLOC_COUNT, new AttributeColumn("Alloc Count", () -> new SimpleColumnRenderer(value -> Integer.toString(((ClassifierSet)value.getAdapter()).getAllocatedCount()), value -> null, 4), 4, 80, MemoryClassifierView.createTreeNodeComparator(Comparator.comparingInt(ClassifierSet::getAllocatedCount), Comparator.comparingInt(ClassifierSet::getAllocatedCount))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.DEALLOC_COUNT, new AttributeColumn("Dealloc Count", () -> new SimpleColumnRenderer(value -> Integer.toString(((ClassifierSet)value.getAdapter()).getDeallocatedCount()), value -> null, 4), 4, 80, MemoryClassifierView.createTreeNodeComparator(Comparator.comparingInt(ClassifierSet::getDeallocatedCount), Comparator.comparingInt(ClassifierSet::getDeallocatedCount))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.NATIVE_SIZE, new AttributeColumn("Native Size", () -> new SimpleColumnRenderer(value -> Long.toString(((ClassifierSet)value.getAdapter()).getTotalNativeSize()), value -> null, 4), 4, 80, MemoryClassifierView.createTreeNodeComparator(Comparator.comparingLong(ClassifierSet::getTotalNativeSize))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.SHALLOW_SIZE, new AttributeColumn("Shallow Size", () -> new SimpleColumnRenderer(value -> Long.toString(((ClassifierSet)value.getAdapter()).getTotalShallowSize()), value -> null, 4), 4, 80, MemoryClassifierView.createTreeNodeComparator(Comparator.comparingLong(ClassifierSet::getTotalShallowSize))));
        this.myAttributeColumns.put(CaptureObject.ClassifierAttribute.RETAINED_SIZE, new AttributeColumn("Retained Size", () -> new SimpleColumnRenderer(value -> Long.toString(((ClassifierSet)value.getAdapter()).getTotalRetainedSize()), value -> null, 4), 4, 80, MemoryClassifierView.createTreeNodeComparator(Comparator.comparingLong(ClassifierSet::getTotalRetainedSize), Comparator.comparingLong(ClassifierSet::getTotalRetainedSize))));
    }

    @NotNull
    JComponent getComponent() {
        return this.myPanel;
    }

    @VisibleForTesting
    @Nullable
    JTree getTree() {
        return this.myTree;
    }

    @VisibleForTesting
    @Nullable
    JComponent getColumnTree() {
        return this.myColumnTree;
    }

    @VisibleForTesting
    @Nullable
    TableColumnModel getTableColumnModel() {
        return this.myTableColumnModel;
    }

    private void reset() {
        this.myCaptureObject = null;
        this.myHeapSet = null;
        this.myClassSet = null;
        this.myColumnTree = null;
        this.myTree = null;
        this.myTreeRoot = null;
        this.myTreeModel = null;
        this.myPanel.removeAll();
        this.myStage.selectClassSet(null);
    }

    private void loadCapture() {
        if (this.myStage.getSelectedCapture() == null || this.myCaptureObject != this.myStage.getSelectedCapture()) {
            this.reset();
        }
    }

    private void refreshCapture() {
        this.myCaptureObject = this.myStage.getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.reset();
            return;
        }
        assert (this.myColumnTree == null && this.myTreeModel == null && this.myTreeRoot == null && this.myTree == null);
        this.myTree = new JTree();
        int defaultFontHeight = this.myTree.getFontMetrics(this.myTree.getFont()).getHeight();
        this.myTree.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myTree.setBorder(ProfilerLayout.TABLE_ROW_BORDER);
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MemoryClassifierView.this.myTree.getSelectionCount() == 0) {
                    MemoryClassifierView.this.myTree.setSelectionRow(0);
                }
            }
        });
        this.myTree.addTreeSelectionListener(e -> {
            TreePath path = e.getPath();
            if (!e.isAddedPath()) {
                return;
            }
            assert (path.getLastPathComponent() instanceof MemoryClassifierTreeNode);
            MemoryClassifierTreeNode classifierNode = (MemoryClassifierTreeNode)path.getLastPathComponent();
            this.myClassifierSet = (ClassifierSet)classifierNode.getAdapter();
            if (classifierNode.getAdapter() instanceof ClassSet && this.myClassSet != classifierNode.getAdapter()) {
                this.myClassSet = (ClassSet)classifierNode.getAdapter();
                this.myStage.selectClassSet(this.myClassSet);
            }
        });
        this.myIdeProfilerComponents.installNavigationContextMenu(this.myTree, this.myStage.getStudioProfilers().getIdeServices().getCodeNavigator(), () -> {
            TreePath selection = this.myTree.getSelectionPath();
            if (selection == null || !(selection.getLastPathComponent() instanceof MemoryObjectTreeNode)) {
                return null;
            }
            if (((MemoryObjectTreeNode)selection.getLastPathComponent()).getAdapter() instanceof ClassSet) {
                ClassSet classSet = (ClassSet)((MemoryObjectTreeNode)selection.getLastPathComponent()).getAdapter();
                return new CodeLocation.Builder(classSet.getClassEntry().getClassName()).build();
            }
            return null;
        });
        List<CaptureObject.ClassifierAttribute> attributes = this.myCaptureObject.getClassifierAttributes();
        this.myTableColumnModel = new DefaultTableColumnModel();
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.myTree, this.myTableColumnModel);
        CaptureObject.ClassifierAttribute sortAttribute = Collections.max(attributes, Comparator.comparingInt(CaptureObject.ClassifierAttribute::getWeight));
        for (CaptureObject.ClassifierAttribute attribute : attributes) {
            AttributeColumn<ClassifierSet> column = this.myAttributeColumns.get((Object)attribute);
            ColumnTreeBuilder.ColumnBuilder columnBuilder = column.getBuilder();
            if (sortAttribute == attribute) {
                columnBuilder.setInitialOrder(attribute.getSortOrder());
                this.myInitialComparator = attribute.getSortOrder() == SortOrder.ASCENDING ? column.getComparator() : Collections.reverseOrder(column.getComparator());
            }
            builder.addColumn(columnBuilder);
        }
        builder.setTreeSorter((comparator, sortOrder) -> {
            if (this.myTreeRoot != null && this.myTreeModel != null) {
                TreePath selectionPath = this.myTree.getSelectionPath();
                this.myTreeRoot.sort(comparator);
                this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
                if (selectionPath != null) {
                    this.myTree.expandPath(selectionPath.getParentPath());
                    this.myTree.setSelectionPath(selectionPath);
                    this.myTree.scrollPathToVisible(selectionPath);
                }
            }
        });
        builder.setHoverColor(ProfilerColors.DEFAULT_HOVER_COLOR);
        builder.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        builder.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        builder.setShowVerticalLines(true);
        this.myColumnTree = builder.build();
        this.myPanel.add((Component)this.myColumnTree, "Center");
    }

    private void startHeapLoadingUi() {
        if (this.myColumnTree == null) {
            return;
        }
        this.myPanel.remove(this.myColumnTree);
        this.myPanel.add((Component)this.myLoadingPanel.getComponent(), "Center");
        this.myLoadingPanel.setChildComponent(this.myColumnTree);
        this.myLoadingPanel.startLoading();
    }

    private void stopHeapLoadingUi() {
        if (this.myColumnTree == null) {
            return;
        }
        this.myPanel.remove(this.myLoadingPanel.getComponent());
        this.myPanel.add((Component)this.myColumnTree, "Center");
        this.myLoadingPanel.setChildComponent(null);
        this.myLoadingPanel.stopLoading();
    }

    private void refreshTree() {
        if (this.myHeapSet == null) {
            return;
        }
        assert (this.myTreeRoot != null);
        this.myTreeRoot.reset();
        this.myTreeRoot.expandNode();
        this.myTreeModel.nodeStructureChanged(this.myTreeRoot);
        if (this.myClassifierSet != null) {
            if (!this.myClassifierSet.isEmpty()) {
                MemoryObjectTreeNode<ClassifierSet> nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode(this.myTreeRoot, this.myClassifierSet);
                if (nodeToSelect != null && nodeToSelect.getAdapter().equals(this.myClassifierSet)) {
                    TreePath treePath = new TreePath(nodeToSelect.getPathToRoot().toArray());
                    this.myTree.expandPath(treePath.getParentPath());
                    this.myTree.setSelectionPath(treePath);
                    this.myTree.scrollPathToVisible(treePath);
                } else {
                    this.myClassifierSet = null;
                }
            } else {
                this.myClassifierSet = null;
            }
        }
    }

    private void refreshHeapSet() {
        assert (this.myCaptureObject != null && this.myTree != null);
        HeapSet heapSet = this.myStage.getSelectedHeapSet();
        if (heapSet == this.myHeapSet) {
            return;
        }
        this.myHeapSet = heapSet;
        if (this.myHeapSet != null) {
            this.refreshGrouping();
        }
    }

    private void refreshGrouping() {
        ClassifierSet classifierSet;
        assert (this.myCaptureObject != null && this.myTree != null);
        Comparator comparator = this.myTreeRoot == null ? this.myInitialComparator : this.myTreeRoot.getComparator();
        HeapSet heapSet = this.myStage.getSelectedHeapSet();
        assert (heapSet != null);
        heapSet.setClassGrouping(this.myStage.getConfiguration().getClassGrouping());
        this.myTreeRoot = new MemoryClassifierTreeNode(heapSet);
        this.myTreeRoot.expandNode();
        if (comparator != null) {
            this.myTreeRoot.sort(comparator);
        }
        this.myTreeModel = new DefaultTreeModel(this.myTreeRoot);
        this.myTree.setModel(this.myTreeModel);
        assert (this.myColumnTree != null);
        String headerName = null;
        switch (this.myStage.getConfiguration().getClassGrouping()) {
            case ARRANGE_BY_CLASS: {
                headerName = "Class Name";
                break;
            }
            case ARRANGE_BY_CALLSTACK: {
                headerName = "Callstack Name";
                break;
            }
            case ARRANGE_BY_PACKAGE: {
                headerName = "Package Name";
            }
        }
        this.myTableColumnModel.getColumn(0).setHeaderValue(headerName);
        ClassSet selectedClassSet = this.myStage.getSelectedClassSet();
        InstanceObject selectedInstance = this.myStage.getSelectedInstanceObject();
        List<FieldObject> fieldPath = this.myStage.getSelectedFieldObjectPath();
        if (selectedClassSet == null) {
            return;
        }
        MemoryObjectTreeNode<ClassifierSet> nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode(this.myTreeRoot, selectedClassSet);
        if (!(nodeToSelect != null && nodeToSelect.getAdapter() instanceof ClassSet || selectedInstance == null || (classifierSet = ((ClassifierSet)this.myTreeRoot.getAdapter()).findContainingClassifierSet(selectedInstance)) == null)) {
            nodeToSelect = MemoryClassifierView.findSmallestSuperSetNode(this.myTreeRoot, classifierSet);
        }
        if (nodeToSelect == null || !(nodeToSelect.getAdapter() instanceof ClassSet)) {
            this.myStage.selectClassSet(null);
            return;
        }
        assert (this.myTree != null);
        TreePath treePath = new TreePath(nodeToSelect.getPathToRoot().toArray());
        this.myClassSet = (ClassSet)nodeToSelect.getAdapter();
        this.myTree.expandPath(treePath.getParentPath());
        this.myTree.setSelectionPath(treePath);
        this.myTree.scrollPathToVisible(treePath);
        this.myStage.selectClassSet(this.myClassSet);
        this.myStage.selectInstanceObject(selectedInstance);
        this.myStage.selectFieldObjectPath(fieldPath);
    }

    @Nullable
    private static MemoryObjectTreeNode<ClassifierSet> findSmallestSuperSetNode(@NotNull MemoryObjectTreeNode<ClassifierSet> rootNode, @NotNull ClassifierSet targetSet) {
        if (rootNode.getAdapter().isSupersetOf(targetSet)) {
            for (MemoryObjectTreeNode child : rootNode.getChildren()) {
                MemoryObjectTreeNode<ClassifierSet> result = MemoryClassifierView.findSmallestSuperSetNode(child, targetSet);
                if (result == null) continue;
                return result;
            }
            return rootNode;
        }
        return null;
    }

    private void refreshClassSet() {
        if (this.myTreeRoot == null || this.myTreeModel == null || this.myTree == null || this.myClassSet == this.myStage.getSelectedClassSet()) {
            return;
        }
        this.myClassSet = this.myStage.getSelectedClassSet();
        if (this.myClassSet != null && !this.myClassSet.isEmpty()) {
            MemoryObjectTreeNode<ClassifierSet> node = MemoryClassifierView.findSmallestSuperSetNode(this.myTreeRoot, this.myClassSet);
            if (node != null) {
                TreePath treePath = new TreePath(node.getPathToRoot().toArray());
                this.myTree.expandPath(treePath.getParentPath());
                this.myTree.setSelectionPath(treePath);
                this.myTree.scrollPathToVisible(treePath);
            } else {
                this.myClassSet = null;
                this.myStage.selectClassSet(null);
            }
        }
        if (this.myClassSet == null) {
            this.myClassifierSet = null;
        }
    }

    @NotNull
    private ColoredTreeCellRenderer getNameColumnRenderer() {
        return new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof MemoryObjectTreeNode)) {
                    return;
                }
                MemoryObjectTreeNode node = (MemoryObjectTreeNode)value;
                if (node.getAdapter() instanceof ClassSet) {
                    ClassSet classSet = (ClassSet)node.getAdapter();
                    this.setIcon(((ClassSet)node.getAdapter()).hasStackInfo() ? StudioIcons.Profiler.Overlays.CLASS_STACK : PlatformIcons.CLASS_ICON);
                    String className = classSet.getClassEntry().getSimpleClassName();
                    String packageName = classSet.getClassEntry().getPackageName();
                    this.append(className, SimpleTextAttributes.REGULAR_ATTRIBUTES, className);
                    if (MemoryClassifierView.this.myStage.getConfiguration().getClassGrouping() == MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS && !packageName.isEmpty()) {
                        String packageText = " (" + packageName + ")";
                        this.append(packageText, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, packageText);
                    }
                } else if (node.getAdapter() instanceof PackageSet) {
                    ClassifierSet set = (ClassifierSet)node.getAdapter();
                    this.setIcon(set.hasStackInfo() ? StudioIcons.Profiler.Overlays.PACKAGE_STACK : PlatformIcons.PACKAGE_ICON);
                    String name = set.getName();
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                } else if (node.getAdapter() instanceof MethodSet) {
                    this.setIcon(PlatformIcons.METHOD_ICON);
                    MethodSet methodObject = (MethodSet)node.getAdapter();
                    String name = methodObject.getMethodName();
                    String className = methodObject.getClassName();
                    if (name != null) {
                        String nameAndLine = name + "()";
                        this.append(nameAndLine, SimpleTextAttributes.REGULAR_ATTRIBUTES, nameAndLine);
                    } else {
                        name = "<unknown method>";
                        this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                    }
                    String classNameText = " (" + className + ")";
                    this.append(classNameText, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES, classNameText);
                } else if (node.getAdapter() instanceof ThreadSet) {
                    this.setIcon(AllIcons.Debugger.ThreadSuspended);
                    String threadName = node.getAdapter().getName();
                    this.append(threadName, SimpleTextAttributes.REGULAR_ATTRIBUTES, threadName);
                } else if (node.getAdapter() instanceof HeapSet) {
                    ClassifierSet set = (ClassifierSet)node.getAdapter();
                    this.setIcon(set.hasStackInfo() ? StudioIcons.Profiler.Overlays.PACKAGE_STACK : PlatformIcons.PACKAGE_ICON);
                    String name = set.getName() + " heap";
                    this.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES, name);
                }
                this.setTextAlign(2);
            }
        };
    }

    @VisibleForTesting
    static Comparator<MemoryObjectTreeNode<ClassifierSet>> createTreeNodeComparator(@NotNull Comparator<ClassifierSet> classifierSetComparator, @NotNull Comparator<ClassSet> classSetComparator) {
        return (o1, o2) -> {
            ClassifierSet firstArg = (ClassifierSet)o1.getAdapter();
            ClassifierSet secondArg = (ClassifierSet)o2.getAdapter();
            int compareResult = firstArg instanceof ClassSet && secondArg instanceof ClassSet ? classSetComparator.compare((ClassSet)firstArg, (ClassSet)secondArg) : (firstArg instanceof ClassSet ? 1 : (secondArg instanceof ClassSet ? -1 : classifierSetComparator.compare(firstArg, secondArg)));
            return compareResult;
        };
    }

    @VisibleForTesting
    static Comparator<MemoryObjectTreeNode<ClassifierSet>> createTreeNodeComparator(@NotNull Comparator<ClassSet> classObjectComparator) {
        return MemoryClassifierView.createTreeNodeComparator(Comparator.comparing(ClassifierSet::getName), classObjectComparator);
    }

    private static class MemoryClassifierTreeNode
    extends LazyMemoryObjectTreeNode<ClassifierSet> {
        private MemoryClassifierTreeNode(@NotNull ClassifierSet classifierSet) {
            super(classifierSet, false);
        }

        @Override
        public void add(@NotNull MemoryObjectTreeNode child) {
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                super.add(child);
                ++this.myMemoizedChildrenCount;
            }
        }

        @Override
        public void remove(@NotNull MutableTreeNode child) {
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                super.remove(child);
                --this.myMemoizedChildrenCount;
            }
        }

        @Override
        public int computeChildrenCount() {
            return ((ClassifierSet)this.getAdapter()).getChildrenClassifierSets().size();
        }

        @Override
        public void expandNode() {
            if (this.myMemoizedChildrenCount == this.myChildren.size()) {
                return;
            }
            this.getChildCount();
            ((ClassifierSet)this.getAdapter()).getChildrenClassifierSets().forEach(set -> {
                MemoryClassifierTreeNode node = new MemoryClassifierTreeNode((ClassifierSet)set);
                node.setTreeModel(this.getTreeModel());
                this.insert(node, this.myChildren.size());
            });
        }
    }
}

