/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryUsage;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class MemoryMonitor
extends ProfilerMonitor {
    @NotNull
    private final AxisComponentModel myMemoryAxis;
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 2, 5);
    private final MemoryUsage myMemoryUsage;
    private final MemoryLegend myMemoryLegend;
    private MemoryLegend myTooltipLegend;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryMonitor.class);
    }

    public MemoryMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        this.myMemoryUsage = new MemoryUsage(profilers);
        this.myMemoryAxis = new AxisComponentModel(this.myMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER);
        this.myMemoryAxis.setClampToMajorTicks(true);
        this.myMemoryLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getDataRange(), 100);
        this.myTooltipLegend = new MemoryLegend(this.myMemoryUsage, this.getTimeline().getTooltipRange(), 0);
    }

    @Override
    public String getName() {
        return "MEMORY";
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryAxis);
        this.myProfilers.getUpdater().register((Updatable)this.myMemoryLegend);
        this.myProfilers.getUpdater().register((Updatable)this.myTooltipLegend);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.myProfilers.getUpdater().unregister((Updatable)this.myMemoryLegend);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTooltipLegend);
        this.myProfilers.removeDependencies((AspectObserver)this);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new MemoryProfilerStage(this.myProfilers));
    }

    public AxisComponentModel getMemoryAxis() {
        return this.myMemoryAxis;
    }

    public MemoryUsage getMemoryUsage() {
        return this.myMemoryUsage;
    }

    public MemoryLegend getMemoryLegend() {
        return this.myMemoryLegend;
    }

    public MemoryLegend getTooltipLegend() {
        return this.myTooltipLegend;
    }

    public static class MemoryLegend
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myTotalLegend;

        public MemoryLegend(@NotNull MemoryUsage usage, @NotNull Range range, int updateFrequencyMs) {
            super(updateFrequencyMs);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.add((Legend)this.myTotalLegend);
        }

        @NotNull
        public Legend getTotalLegend() {
            return this.myTotalLegend;
        }
    }
}

