/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.memory.CaptureEntry;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryProfilerSelection {
    @NotNull
    private final MemoryProfilerStage myStage;
    @Nullable
    private CaptureEntry myCaptureEntry;
    @Nullable
    private CaptureObject myCaptureObject;
    @Nullable
    private HeapSet myHeapSet;
    @Nullable
    private ClassSet myClassSet;
    @Nullable
    private InstanceObject myInstanceObject;
    @NotNull
    private List<FieldObject> myFieldObjectPath = Collections.emptyList();

    public MemoryProfilerSelection(@NotNull MemoryProfilerStage stage) {
        this.myStage = stage;
    }

    @Nullable
    public CaptureObject getCaptureObject() {
        return this.myCaptureObject;
    }

    @Nullable
    public HeapSet getHeapSet() {
        return this.myHeapSet;
    }

    @Nullable
    public ClassSet getClassSet() {
        return this.myClassSet;
    }

    @Nullable
    public InstanceObject getInstanceObject() {
        return this.myInstanceObject;
    }

    @NotNull
    public List<FieldObject> getFieldObjectPath() {
        return this.myFieldObjectPath;
    }

    public boolean selectCaptureEntry(@Nullable CaptureEntry<? extends CaptureObject> captureEntry) {
        if (Objects.equals(this.myCaptureEntry, captureEntry)) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(null);
        this.setHeapSet(null);
        if (this.myCaptureObject != null) {
            this.myCaptureObject.unload();
        }
        this.myCaptureEntry = captureEntry;
        this.myCaptureObject = this.myCaptureEntry == null ? null : captureEntry.getCaptureObject();
        this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE);
        return true;
    }

    public boolean finishSelectingCaptureObject(@Nullable CaptureObject captureObject) {
        if (captureObject != null && captureObject == this.myCaptureObject && !captureObject.isError() && captureObject.isDoneLoading()) {
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE);
            return true;
        }
        return false;
    }

    public boolean selectHeapSet(@Nullable HeapSet heapSet) {
        assert (heapSet == null || this.myCaptureObject != null);
        if (this.myHeapSet == heapSet) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(null);
        this.setHeapSet(heapSet);
        return true;
    }

    public boolean selectClassSet(@Nullable ClassSet classSet) {
        assert (classSet == null || this.myCaptureObject != null);
        if (this.myClassSet == classSet) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(null);
        this.setClassSet(classSet);
        return true;
    }

    public boolean selectInstanceObject(@Nullable InstanceObject instanceObject) {
        assert (instanceObject == null || this.myCaptureObject != null);
        if (this.myInstanceObject == instanceObject) {
            return false;
        }
        this.setFieldObjectPath(Collections.emptyList());
        this.setInstanceObject(instanceObject);
        return true;
    }

    public boolean selectFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        assert (fieldObjectPath.isEmpty() || this.myCaptureObject != null && this.myInstanceObject != null);
        if (Objects.equals(this.myFieldObjectPath, fieldObjectPath)) {
            return false;
        }
        this.setFieldObjectPath(fieldObjectPath);
        return true;
    }

    private void setHeapSet(@Nullable HeapSet heapSet) {
        if (this.myHeapSet != heapSet) {
            this.myHeapSet = heapSet;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP);
        }
    }

    private void setClassSet(@Nullable ClassSet classSet) {
        if (this.myClassSet != classSet) {
            this.myClassSet = classSet;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_CLASS);
        }
    }

    private void setInstanceObject(@Nullable InstanceObject instanceObject) {
        if (this.myInstanceObject != instanceObject) {
            this.myInstanceObject = instanceObject;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_INSTANCE);
        }
    }

    public void setFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        if (this.myFieldObjectPath != fieldObjectPath) {
            this.myFieldObjectPath = fieldObjectPath;
            this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_FIELD_PATH);
        }
    }
}

