/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.SelectionComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.chart.linechart.OverlayComponent;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.flat.FlatButton;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.MemoryCaptureView;
import com.android.tools.profilers.memory.MemoryClassGrouping;
import com.android.tools.profilers.memory.MemoryClassSetView;
import com.android.tools.profilers.memory.MemoryClassifierView;
import com.android.tools.profilers.memory.MemoryHeapView;
import com.android.tools.profilers.memory.MemoryInstanceDetailsView;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.MemoryStageTooltipView;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.ReferenceObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.Gray;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.PlatformIcons;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStageView
extends StageView<MemoryProfilerStage> {
    @NotNull
    private final MemoryCaptureView myCaptureView = new MemoryCaptureView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryHeapView myHeapView = new MemoryHeapView((MemoryProfilerStage)this.getStage());
    @NotNull
    private final MemoryClassifierView myClassifierView = new MemoryClassifierView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryClassGrouping myClassGrouping = new MemoryClassGrouping((MemoryProfilerStage)this.getStage());
    @NotNull
    private final MemoryClassSetView myClassSetView = new MemoryClassSetView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryInstanceDetailsView myInstanceDetailsView = new MemoryInstanceDetailsView((MemoryProfilerStage)this.getStage(), this.getIdeComponents());
    @NotNull
    private final MemoryStageTooltipView myMemoryStageTooltipView = new MemoryStageTooltipView((MemoryProfilerStage)this.getStage());
    @Nullable
    private CaptureObject myCaptureObject = null;
    @NotNull
    private final JBSplitter myMainSplitter = new JBSplitter(false);
    @NotNull
    private final JBSplitter myChartCaptureSplitter = new JBSplitter(true);
    @NotNull
    private final JPanel myCapturePanel;
    @Nullable
    private LoadingPanel myCaptureLoadingPanel;
    @NotNull
    private final JBSplitter myInstanceDetailsSplitter = new JBSplitter(true);
    @NotNull
    private JButton myHeapDumpButton;
    @NotNull
    private JButton myAllocationButton;
    @NotNull
    private final JLabel myCaptureElapsedTime;

    public MemoryProfilerStageView(@NotNull StudioProfilersView profilersView, @NotNull MemoryProfilerStage stage) {
        super(profilersView, stage);
        ((MemoryProfilerStage)this.getStage()).enableSelectLatestCapture(true, SwingUtilities::invokeLater);
        this.myMainSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_VERTICAL_BORDERS);
        this.myChartCaptureSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.myInstanceDetailsSplitter.getDivider().setBorder(AdtUiUtils.DEFAULT_HORIZONTAL_BORDERS);
        this.myChartCaptureSplitter.setFirstComponent((JComponent)this.buildMonitorUi());
        this.myCapturePanel = this.buildCaptureUi();
        this.myInstanceDetailsSplitter.setOpaque(true);
        this.myInstanceDetailsSplitter.setFirstComponent(this.myClassSetView.getComponent());
        this.myInstanceDetailsSplitter.setSecondComponent(this.myInstanceDetailsView.getComponent());
        this.myMainSplitter.setFirstComponent((JComponent)this.myChartCaptureSplitter);
        this.myMainSplitter.setSecondComponent((JComponent)this.myInstanceDetailsSplitter);
        this.myMainSplitter.setProportion(0.6f);
        this.getComponent().add((Component)this.myMainSplitter, "Center");
        this.myHeapDumpButton = new FlatButton(StudioIcons.Profiler.Toolbar.HEAP_DUMP);
        this.myHeapDumpButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.HEAP_DUMP));
        this.myHeapDumpButton.setToolTipText("Dump Java heap");
        this.myHeapDumpButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).requestHeapDump();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackDumpHeap();
        });
        this.myCaptureElapsedTime = new JLabel("");
        this.myCaptureElapsedTime.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(12.0f));
        this.myCaptureElapsedTime.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.myCaptureElapsedTime.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        this.myAllocationButton = new FlatButton();
        this.myAllocationButton.setText("");
        this.myAllocationButton.addActionListener(e -> {
            if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
                ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackRecordAllocations();
            }
            ((MemoryProfilerStage)this.getStage()).trackAllocations(!((MemoryProfilerStage)this.getStage()).isTrackingAllocations());
        });
        this.myAllocationButton.setVisible(!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking());
        ((MemoryProfilerStage)this.getStage()).getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::captureObjectChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::captureObjectFinishedLoading).onChange((Enum)MemoryProfilerAspect.TRACKING_ENABLED, this::allocationTrackingChanged).onChange((Enum)MemoryProfilerAspect.CURRENT_CAPTURE_ELAPSED_TIME, this::updateCaptureElapsedTime);
        this.captureObjectChanged();
        this.allocationTrackingChanged();
    }

    @Override
    public JComponent getToolbar() {
        JPanel toolBar = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        FlatButton forceGarbageCollectionButton = new FlatButton(StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION);
        forceGarbageCollectionButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION));
        forceGarbageCollectionButton.setToolTipText("Force garbage collection");
        forceGarbageCollectionButton.addActionListener(e -> {
            ((MemoryProfilerStage)this.getStage()).forceGarbageCollection();
            ((MemoryProfilerStage)this.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker().trackForceGc();
        });
        toolBar.add((Component)forceGarbageCollectionButton);
        toolBar.add(this.myHeapDumpButton);
        toolBar.add(this.myAllocationButton);
        toolBar.add(this.myCaptureElapsedTime);
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        Runnable toggleButtons = () -> this.lambda$getToolbar$3((JButton)forceGarbageCollectionButton, profilers);
        profilers.addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, toggleButtons);
        toggleButtons.run();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)toolBar, "West");
        return panel;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getMainSplitter() {
        return this.myMainSplitter;
    }

    @VisibleForTesting
    @NotNull
    public Splitter getChartCaptureSplitter() {
        return this.myChartCaptureSplitter;
    }

    @VisibleForTesting
    @NotNull
    public JPanel getCapturePanel() {
        return this.myCapturePanel;
    }

    @VisibleForTesting
    @NotNull
    MemoryCaptureView getCaptureView() {
        return this.myCaptureView;
    }

    @VisibleForTesting
    @NotNull
    MemoryHeapView getHeapView() {
        return this.myHeapView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassGrouping getClassGrouping() {
        return this.myClassGrouping;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassifierView getClassifierView() {
        return this.myClassifierView;
    }

    @VisibleForTesting
    @NotNull
    MemoryClassSetView getClassSetView() {
        return this.myClassSetView;
    }

    @VisibleForTesting
    @NotNull
    MemoryInstanceDetailsView getInstanceDetailsView() {
        return this.myInstanceDetailsView;
    }

    @VisibleForTesting
    @NotNull
    JLabel getCaptureElapsedTimeLabel() {
        return this.myCaptureElapsedTime;
    }

    private void allocationTrackingChanged() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations()) {
            this.myAllocationButton.setIcon(StudioIcons.Profiler.Toolbar.STOP_RECORDING);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.STOP_RECORDING));
            this.myAllocationButton.setToolTipText("Stop recording");
            this.myCaptureElapsedTime.setText("Recording - " + TimeAxisFormatter.DEFAULT.getFormattedString(0.0, 0.0, true));
        } else {
            this.myCaptureElapsedTime.setText("");
            this.myAllocationButton.setIcon(StudioIcons.Profiler.Toolbar.RECORD);
            this.myAllocationButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.Profiler.Toolbar.RECORD));
            this.myAllocationButton.setToolTipText("Record memory allocations");
        }
    }

    private void updateCaptureElapsedTime() {
        if (((MemoryProfilerStage)this.getStage()).isTrackingAllocations() && !((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            long elapsedTimeUs = TimeUnit.NANOSECONDS.toMicros(((MemoryProfilerStage)this.getStage()).getAllocationTrackingElapsedTimeNs());
            this.myCaptureElapsedTime.setText("Recording - " + TimeAxisFormatter.DEFAULT.getFormattedString((double)elapsedTimeUs, (double)elapsedTimeUs, true));
        }
    }

    @NotNull
    private JPanel buildMonitorUi() {
        StudioProfilers profilers = ((MemoryProfilerStage)this.getStage()).getStudioProfilers();
        ProfilerTimeline timeline = profilers.getTimeline();
        Range viewRange = this.getTimeline().getViewRange();
        TabularLayout layout = new TabularLayout("*");
        JBPanel panel = new JBPanel((LayoutManager)layout);
        panel.setBackground(ProfilerColors.DEFAULT_STAGE_BACKGROUND);
        ProfilerScrollbar sb = new ProfilerScrollbar(timeline, (JComponent)panel);
        panel.add((Component)((Object)sb), new TabularLayout.Constraint(3, 0));
        JComponent timeAxis = this.buildTimeAxis(profilers);
        panel.add((Component)timeAxis, new TabularLayout.Constraint(2, 0));
        EventMonitorView eventsView = new EventMonitorView(this.getProfilersView(), ((MemoryProfilerStage)this.getStage()).getEventMonitor());
        panel.add((Component)eventsView.getComponent(), new TabularLayout.Constraint(0, 0));
        JBPanel monitorPanel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
        monitorPanel.setOpaque(false);
        monitorPanel.setBorder(ProfilerLayout.MONITOR_BORDER);
        JLabel label = new JLabel(((MemoryProfilerStage)this.getStage()).getName());
        label.setBorder(ProfilerLayout.MONITOR_LABEL_PADDING);
        label.setVerticalAlignment(1);
        JBPanel lineChartPanel = new JBPanel((LayoutManager)new BorderLayout());
        lineChartPanel.setOpaque(false);
        DetailedMemoryUsage memoryUsage = ((MemoryProfilerStage)this.getStage()).getDetailedMemoryUsage();
        LineChart lineChart = new LineChart((LineChartModel)memoryUsage);
        if (((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA_CAPTURED, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE_CAPTURED, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS_CAPTURED, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK_CAPTURED, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE_CAPTURED, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS_CAPTURED, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS_CAPUTRED).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        } else {
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_JAVA, memoryUsage.getJavaSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_NATIVE, memoryUsage.getNativeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_GRAPHICS, memoryUsage.getGraphicsSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_STACK, memoryUsage.getStackSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_CODE, memoryUsage.getCodeSeries());
            MemoryProfilerStageView.configureStackedFilledLine(lineChart, ProfilerColors.MEMORY_OTHERS, memoryUsage.getOtherSeries());
            lineChart.configure(memoryUsage.getObjectsSeries(), new LineConfig(ProfilerColors.MEMORY_OBJECTS).setStroke((Stroke)LineConfig.DEFAULT_DASH_STROKE).setLegendIconType(LegendConfig.IconType.DASHED_LINE));
        }
        lineChart.configure(memoryUsage.getTotalMemorySeries(), new LineConfig(new Color(0, 0, 0, 0)));
        lineChart.setRenderOffset(0, (int)LineConfig.DEFAULT_DASH_STROKE.getLineWidth() / 2);
        lineChart.setTopPadding(ProfilerLayout.Y_AXIS_TOP_MARGIN);
        lineChart.setFillEndGap(true);
        DurationDataRenderer gcRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getGcStats(), Color.BLACK).setIcon(StudioIcons.Profiler.Events.GARBAGE_EVENT).setLabelOffsets((float)(-StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconHeight() / 2.0f).build();
        lineChart.addCustomRenderer((LineChartCustomRenderer)gcRenderer);
        SelectionComponent selection = new SelectionComponent(((MemoryProfilerStage)this.getStage()).getSelectionModel());
        JBPanel overlayPanel = new JBPanel((LayoutManager)new BorderLayout());
        overlayPanel.setOpaque(false);
        overlayPanel.setBorder(BorderFactory.createEmptyBorder(ProfilerLayout.Y_AXIS_TOP_MARGIN, 0, 0, 0));
        OverlayComponent overlay = new OverlayComponent((Component)selection);
        overlay.addDurationDataRenderer(gcRenderer);
        overlayPanel.add((Component)overlay, "Center");
        if (!((MemoryProfilerStage)this.getStage()).useLiveAllocationTracking()) {
            DurationDataRenderer allocationRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getAllocationInfosDurations(), Color.LIGHT_GRAY).setDurationBg(ProfilerColors.MEMORY_ALLOC_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Allocation record (%s)", data.getDuration() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDuration(), true))).build();
            allocationRenderer.addCustomLineConfig(memoryUsage.getJavaSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getJavaSeries())).setColor(ProfilerColors.MEMORY_JAVA_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getNativeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getNativeSeries())).setColor(ProfilerColors.MEMORY_NATIVE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getGraphicsSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getGraphicsSeries())).setColor(ProfilerColors.MEMORY_GRAPHICS_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getStackSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getStackSeries())).setColor(ProfilerColors.MEMORY_STACK_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getCodeSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getCodeSeries())).setColor(ProfilerColors.MEMORY_CODE_CAPTURED));
            allocationRenderer.addCustomLineConfig(memoryUsage.getOtherSeries(), LineConfig.copyOf((LineConfig)lineChart.getLineConfig(memoryUsage.getOtherSeries())).setColor(ProfilerColors.MEMORY_OTHERS_CAPTURED));
            lineChart.addCustomRenderer((LineChartCustomRenderer)allocationRenderer);
            overlay.addDurationDataRenderer(allocationRenderer);
        }
        DurationDataRenderer heapDumpRenderer = new DurationDataRenderer.Builder(((MemoryProfilerStage)this.getStage()).getHeapDumpSampleDurations(), Color.DARK_GRAY).setDurationBg(ProfilerColors.MEMORY_HEAP_DUMP_BG).setLabelColors(Color.DARK_GRAY, Color.GRAY, Color.lightGray, Color.WHITE).setLabelProvider(data -> String.format("Dump (%s)", data.getDuration() == Long.MAX_VALUE ? "in progress" : TimeAxisFormatter.DEFAULT.getFormattedString(viewRange.getLength(), (double)data.getDuration(), true))).build();
        for (RangedContinuousSeries series : memoryUsage.getSeries()) {
            LineConfig config = lineChart.getLineConfig(series);
            int gray = (config.getColor().getBlue() + config.getColor().getRed() + config.getColor().getGreen()) / 3;
            LineConfig newConfig = LineConfig.copyOf((LineConfig)config).setColor((Color)Gray.get((int)gray));
            heapDumpRenderer.addCustomLineConfig(series, newConfig);
        }
        lineChart.addCustomRenderer((LineChartCustomRenderer)heapDumpRenderer);
        overlay.addDurationDataRenderer(heapDumpRenderer);
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), this.myMemoryStageTooltipView.createComponent());
        tooltip.registerListenersOn((Component)overlay);
        tooltip.registerListenersOn((Component)overlayPanel);
        lineChartPanel.add((Component)lineChart, "Center");
        JBPanel axisPanel = new JBPanel((LayoutManager)new BorderLayout());
        axisPanel.setOpaque(false);
        AxisComponent memoryAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getMemoryAxis(), AxisComponent.AxisOrientation.RIGHT);
        memoryAxis.setShowAxisLine(false);
        memoryAxis.setShowMax(true);
        memoryAxis.setShowUnitAtMax(true);
        memoryAxis.setHideTickAtMin(true);
        memoryAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        memoryAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)memoryAxis, "West");
        AxisComponent rightAxis = new AxisComponent(((MemoryProfilerStage)this.getStage()).getObjectsAxis(), AxisComponent.AxisOrientation.LEFT);
        rightAxis.setShowAxisLine(false);
        rightAxis.setShowMax(true);
        rightAxis.setShowUnitAtMax(true);
        rightAxis.setHideTickAtMin(true);
        rightAxis.setMarkerLengths(ProfilerLayout.MARKER_LENGTH, ProfilerLayout.MARKER_LENGTH);
        rightAxis.setMargins(0, ProfilerLayout.Y_AXIS_TOP_MARGIN);
        axisPanel.add((Component)rightAxis, "East");
        MemoryProfilerStage.MemoryStageLegends legends = ((MemoryProfilerStage)this.getStage()).getLegends();
        LegendComponent legend = new LegendComponent.Builder((LegendComponentModel)legends).setRightPadding(ProfilerLayout.PROFILER_LEGEND_RIGHT_PADDING).build();
        legend.configure((Legend)legends.getJavaLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getJavaSeries())));
        legend.configure((Legend)legends.getNativeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getNativeSeries())));
        legend.configure((Legend)legends.getGraphicsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getGraphicsSeries())));
        legend.configure((Legend)legends.getStackLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getStackSeries())));
        legend.configure((Legend)legends.getCodeLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getCodeSeries())));
        legend.configure((Legend)legends.getOtherLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getOtherSeries())));
        legend.configure((Legend)legends.getTotalLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getTotalMemorySeries())));
        legend.configure((Legend)legends.getObjectsLegend(), new LegendConfig(lineChart.getLineConfig(memoryUsage.getObjectsSeries())));
        JBPanel legendPanel = new JBPanel((LayoutManager)new BorderLayout());
        legendPanel.setOpaque(false);
        legendPanel.add((Component)label, "West");
        legendPanel.add((Component)legend, "East");
        monitorPanel.add((Component)tooltip, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)legendPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)overlayPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)selection, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)axisPanel, new TabularLayout.Constraint(0, 0));
        monitorPanel.add((Component)lineChartPanel, new TabularLayout.Constraint(0, 0));
        layout.setRowSizing(1, "*");
        panel.add((Component)monitorPanel, new TabularLayout.Constraint(1, 0));
        return panel;
    }

    @NotNull
    private JPanel buildCaptureUi() {
        JPanel toolbar = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        toolbar.add(this.myCaptureView.getComponent());
        toolbar.add((Component)this.myHeapView.getComponent());
        toolbar.add((Component)this.myClassGrouping.getComponent());
        JPanel headingPanel = new JPanel(new BorderLayout());
        headingPanel.add((Component)toolbar, "West");
        JPanel capturePanel = new JPanel(new BorderLayout());
        capturePanel.add((Component)headingPanel, "First");
        capturePanel.add((Component)this.myClassifierView.getComponent(), "Center");
        return capturePanel;
    }

    private void captureObjectChanged() {
        this.stopLoadingUi();
        this.myCaptureObject = ((MemoryProfilerStage)this.getStage()).getSelectedCapture();
        if (this.myCaptureObject == null) {
            this.myAllocationButton.setEnabled(true);
            this.myHeapDumpButton.setEnabled(true);
            this.myChartCaptureSplitter.setSecondComponent(null);
            return;
        }
        if (this.myCaptureObject.isDoneLoading()) {
            this.captureObjectFinishedLoading();
        } else {
            this.myAllocationButton.setEnabled(false);
            this.myHeapDumpButton.setEnabled(false);
            this.myCaptureLoadingPanel = this.getProfilersView().getIdeProfilerComponents().createLoadingPanel(-1);
            this.myCaptureLoadingPanel.setLoadingText("Fetching results");
            this.myCaptureLoadingPanel.startLoading();
            this.myChartCaptureSplitter.setSecondComponent(this.myCaptureLoadingPanel.getComponent());
        }
    }

    private void captureObjectFinishedLoading() {
        this.myAllocationButton.setEnabled(true);
        this.myHeapDumpButton.setEnabled(true);
        if (this.myCaptureObject != ((MemoryProfilerStage)this.getStage()).getSelectedCapture() || this.myCaptureObject == null) {
            return;
        }
        this.stopLoadingUi();
        this.myChartCaptureSplitter.setSecondComponent((JComponent)this.myCapturePanel);
    }

    private void stopLoadingUi() {
        if (this.myCaptureObject == null || this.myCaptureLoadingPanel == null) {
            return;
        }
        this.myCaptureLoadingPanel.stopLoading();
        this.myCaptureLoadingPanel = null;
        this.myChartCaptureSplitter.setSecondComponent(null);
    }

    private static void configureStackedFilledLine(LineChart chart, Color color, RangedContinuousSeries series) {
        chart.configure(series, new LineConfig(color).setFilled(true).setStacked(true).setLegendIconType(LegendConfig.IconType.BOX));
    }

    @NotNull
    static Icon getValueObjectIcon(@NotNull ValueObject valueObject) {
        if (valueObject instanceof FieldObject) {
            FieldObject field = (FieldObject)valueObject;
            if (field.getValueType() == ValueObject.ValueType.ARRAY) {
                return MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
            }
            if (field.getValueType().getIsPrimitive()) {
                return AllIcons.Debugger.Db_primitive;
            }
            return MemoryProfilerStageView.getStackedIcon(field.getAsInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
        }
        if (valueObject instanceof ReferenceObject) {
            ReferenceObject referrer = (ReferenceObject)valueObject;
            if (referrer.getReferenceInstance().getIsRoot()) {
                return AllIcons.Hierarchy.Subtypes;
            }
            if (referrer.getReferenceInstance().getValueType() == ValueObject.ValueType.ARRAY) {
                return MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.ARRAY_STACK, AllIcons.Debugger.Db_array);
            }
            return MemoryProfilerStageView.getStackedIcon(referrer.getReferenceInstance(), StudioIcons.Profiler.Overlays.FIELD_STACK, PlatformIcons.FIELD_ICON);
        }
        if (valueObject instanceof InstanceObject) {
            return MemoryProfilerStageView.getStackedIcon((InstanceObject)valueObject, StudioIcons.Profiler.Overlays.INTERFACE_STACK, PlatformIcons.INTERFACE_ICON);
        }
        return PlatformIcons.INTERFACE_ICON;
    }

    private static Icon getStackedIcon(@Nullable InstanceObject instance, @NotNull Icon stackedIcon, @NotNull Icon nonStackedIcon) {
        return instance == null || instance.getCallStackDepth() == 0 ? nonStackedIcon : stackedIcon;
    }

    private /* synthetic */ void lambda$getToolbar$3(JButton forceGarbageCollectionButton, StudioProfilers profilers) {
        forceGarbageCollectionButton.setEnabled(profilers.isProcessAlive());
        this.myHeapDumpButton.setEnabled(profilers.isProcessAlive());
        this.myAllocationButton.setEnabled(profilers.isProcessAlive());
    }
}

