/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.memory.MemoryDataSeries;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class MemoryUsage
extends LineChartModel {
    @NotNull
    private final Range myMemoryRange = new Range(0.0, 0.0);
    @NotNull
    private final RangedContinuousSeries myTotalMemorySeries;

    public MemoryUsage(@NotNull StudioProfilers profilers) {
        this.myTotalMemorySeries = this.createRangedSeries(profilers, this.getTotalSeriesLabel(), this.myMemoryRange, MemoryProfiler.MemoryData.MemorySample::getTotalMem);
        this.add(this.myTotalMemorySeries);
    }

    protected RangedContinuousSeries createRangedSeries(StudioProfilers profilers, String name, Range range, Function<MemoryProfiler.MemoryData.MemorySample, Long> getter) {
        MemoryServiceGrpc.MemoryServiceBlockingStub client = profilers.getClient().getMemoryClient();
        MemoryDataSeries series = new MemoryDataSeries(client, profilers.getProcessId(), profilers.getSession(), getter);
        return new RangedContinuousSeries(name, profilers.getTimeline().getViewRange(), range, (DataSeries)series);
    }

    @NotNull
    public Range getMemoryRange() {
        return this.myMemoryRange;
    }

    @NotNull
    public RangedContinuousSeries getTotalMemorySeries() {
        return this.myTotalMemorySeries;
    }

    protected String getTotalSeriesLabel() {
        return "";
    }
}

