/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

class SimpleColumnRenderer<T extends MemoryObject>
extends ColoredTreeCellRenderer {
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, String> myTextGetter;
    @NotNull
    private final Function<MemoryObjectTreeNode<T>, Icon> myIconGetter;
    private final int myAlignment;

    public SimpleColumnRenderer(@NotNull Function<MemoryObjectTreeNode<T>, String> textGetter, @NotNull Function<MemoryObjectTreeNode<T>, Icon> iconGetter, int alignment) {
        this.myTextGetter = textGetter;
        this.myIconGetter = iconGetter;
        this.myAlignment = alignment;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof MemoryObjectTreeNode) {
            String text = this.myTextGetter.apply((MemoryObjectTreeNode)value);
            this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES, text);
            this.setTextAlign(this.myAlignment);
            Icon icon = this.myIconGetter.apply((MemoryObjectTreeNode)value);
            if (icon != null) {
                this.setIcon(icon);
            } else if (this.myAlignment == 2) {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_CELL_INSETS);
            } else {
                this.setIpad(ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_CELL_INSETS);
            }
        }
    }
}

