/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaptureObject
extends MemoryObject {
    public static final int DEFAULT_HEAP_ID = 0;
    public static final int DEFAULT_CLASSLOADER_ID = -1;
    public static final String INVALID_HEAP_NAME = "INVALID";

    @Nullable
    default public Common.Session getSession() {
        return null;
    }

    default public int getProcessId() {
        return -1;
    }

    @Nullable
    default public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        return null;
    }

    default public boolean isExportable() {
        return false;
    }

    @Nullable
    public String getExportableExtension();

    public void saveToFile(@NotNull OutputStream var1) throws IOException;

    @NotNull
    public List<ClassifierAttribute> getClassifierAttributes();

    @NotNull
    public List<InstanceAttribute> getInstanceAttributes();

    @NotNull
    public Collection<HeapSet> getHeapSets();

    @Nullable
    public HeapSet getHeapSet(int var1);

    @NotNull
    public Stream<InstanceObject> getInstances();

    public long getStartTimeNs();

    public long getEndTimeNs();

    public boolean load(@Nullable Range var1, @Nullable Executor var2);

    public boolean isDoneLoading();

    public boolean isError();

    public void unload();

    public static enum InstanceAttribute {
        LABEL(1, SortOrder.ASCENDING),
        ALLOCATION_TIME(2, SortOrder.DESCENDING),
        DEALLOCATION_TIME(3, SortOrder.DESCENDING),
        DEPTH(0, SortOrder.ASCENDING),
        NATIVE_SIZE(4, SortOrder.DESCENDING),
        SHALLOW_SIZE(5, SortOrder.DESCENDING),
        RETAINED_SIZE(6, SortOrder.DESCENDING);

        private final int myWeight;
        @NotNull
        private final SortOrder mySortOrder;

        private InstanceAttribute(int weight, SortOrder sortOrder) {
            this.myWeight = weight;
            this.mySortOrder = sortOrder;
        }

        public int getWeight() {
            return this.myWeight;
        }

        @NotNull
        public SortOrder getSortOrder() {
            return this.mySortOrder;
        }
    }

    public static enum ClassifierAttribute {
        LABEL(0, SortOrder.ASCENDING),
        ALLOC_COUNT(2, SortOrder.DESCENDING),
        DEALLOC_COUNT(1, SortOrder.DESCENDING),
        NATIVE_SIZE(3, SortOrder.DESCENDING),
        SHALLOW_SIZE(4, SortOrder.DESCENDING),
        RETAINED_SIZE(5, SortOrder.DESCENDING);

        private final int myWeight;
        @NotNull
        private final SortOrder mySortOrder;

        private ClassifierAttribute(int weight, SortOrder sortOrder) {
            this.myWeight = weight;
            this.mySortOrder = sortOrder;
        }

        public int getWeight() {
            return this.myWeight;
        }

        @NotNull
        public SortOrder getSortOrder() {
            return this.mySortOrder;
        }
    }
}

