/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ClassSet
extends ClassifierSet {
    public static final ClassSet EMPTY_SET = new ClassSet(new ClassDb.ClassEntry("null"));
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier() {
        return new ClassClassifier();
    }

    public ClassSet(@NotNull ClassDb.ClassEntry classEntry) {
        super(classEntry.getSimpleClassName());
        this.myClassEntry = classEntry;
    }

    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myClassEntry;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        return ClassifierSet.Classifier.IDENTITY_CLASSIFIER;
    }

    private static final class ClassClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();

        private ClassClassifier() {
        }

        @Override
        @NotNull
        public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
            return this.myClassMap.computeIfAbsent(instance.getClassEntry(), ClassSet::new);
        }

        @Override
        @NotNull
        public List<ClassifierSet> getClassifierSets() {
            return this.myClassMap.values().stream().filter(child -> !child.isEmpty()).collect(Collectors.toList());
        }
    }
}

