/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public abstract class ClassifierSet
implements MemoryObject {
    @NotNull
    private String myName;
    @NotNull
    private Supplier<String> myNameSupplier = null;
    @NotNull
    protected final Set<InstanceObject> myInstances = new LinkedHashSet<InstanceObject>(0);
    @Nullable
    protected Classifier myClassifier = null;
    protected int myAllocatedCount = 0;
    protected int myDeallocatedCount = 0;
    protected long myTotalNativeSize = 0L;
    protected long myTotalShallowSize = 0L;
    protected long myTotalRetainedSize = 0L;
    protected int myInstancesWithStackInfoCount = 0;

    public ClassifierSet(@NotNull String name) {
        this.myName = name;
    }

    public ClassifierSet(@NotNull Supplier<String> nameSupplier) {
        this.myNameSupplier = nameSupplier;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            assert (this.myNameSupplier != null);
            this.myName = this.myNameSupplier.get();
        }
        return this.myName;
    }

    public boolean isEmpty() {
        return this.myAllocatedCount == 0 && this.myDeallocatedCount == 0;
    }

    public int getAllocatedCount() {
        return this.myAllocatedCount;
    }

    public int getDeallocatedCount() {
        return this.myDeallocatedCount;
    }

    public long getTotalRetainedSize() {
        return this.myTotalRetainedSize;
    }

    public long getTotalShallowSize() {
        return this.myTotalShallowSize;
    }

    public long getTotalNativeSize() {
        return this.myTotalNativeSize;
    }

    public boolean addInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.addInstanceObjectInformation(instanceObject, true);
    }

    public boolean freeInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.addInstanceObjectInformation(instanceObject, false);
    }

    public boolean removeAddingInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.removeInstanceObjectInformation(instanceObject, true);
    }

    public boolean removeFreeingInstanceObject(@NotNull InstanceObject instanceObject) {
        return this.removeInstanceObjectInformation(instanceObject, false);
    }

    private boolean addInstanceObjectInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        boolean instanceAdded = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceAdded = this.myClassifier.getOrCreateClassifierSet(instanceObject).addInstanceObjectInformation(instanceObject, isAllocation);
        } else if (!this.myInstances.contains(instanceObject)) {
            instanceAdded = true;
            this.myInstances.add(instanceObject);
        }
        if (isAllocation) {
            ++this.myAllocatedCount;
        } else {
            ++this.myDeallocatedCount;
        }
        this.myTotalNativeSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize += (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize += (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceAdded && instanceObject.getCallStackDepth() > 0) {
            ++this.myInstancesWithStackInfoCount;
        }
        return instanceAdded;
    }

    private boolean removeInstanceObjectInformation(@NotNull InstanceObject instanceObject, boolean isAllocation) {
        boolean instanceRemoved = false;
        if (this.myClassifier != null && !this.myClassifier.isTerminalClassifier()) {
            instanceRemoved = this.myClassifier.getOrCreateClassifierSet(instanceObject).removeInstanceObjectInformation(instanceObject, isAllocation);
        } else if (!instanceObject.hasTimeData() && this.myInstances.contains(instanceObject)) {
            this.myInstances.remove(instanceObject);
            instanceRemoved = true;
        }
        if (isAllocation) {
            --this.myAllocatedCount;
        } else {
            --this.myDeallocatedCount;
        }
        this.myTotalNativeSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getNativeSize() == -1L ? 0L : instanceObject.getNativeSize());
        this.myTotalShallowSize -= (long)((isAllocation ? 1 : -1) * (instanceObject.getShallowSize() == -1 ? 0 : instanceObject.getShallowSize()));
        this.myTotalRetainedSize -= (long)(isAllocation ? 1 : -1) * (instanceObject.getRetainedSize() == -1L ? 0L : instanceObject.getRetainedSize());
        if (instanceRemoved && instanceObject.getCallStackDepth() > 0) {
            --this.myInstancesWithStackInfoCount;
        }
        return instanceRemoved;
    }

    public void clearClassifierSets() {
        this.myInstances.clear();
        this.myClassifier = this.createSubClassifier();
        this.myAllocatedCount = 0;
        this.myDeallocatedCount = 0;
        this.myTotalShallowSize = 0L;
        this.myTotalRetainedSize = 0L;
        this.myInstancesWithStackInfoCount = 0;
    }

    public int getInstancesCount() {
        if (this.myClassifier == null) {
            return this.myInstances.size();
        }
        return (int)this.getInstancesStream().count();
    }

    @NotNull
    public Stream<InstanceObject> getInstancesStream() {
        if (this.myClassifier == null) {
            return this.myInstances.stream();
        }
        return Stream.concat(this.getChildrenClassifierSets().stream().flatMap(ClassifierSet::getInstancesStream), this.myInstances.stream());
    }

    public boolean hasStackInfo() {
        return this.myInstancesWithStackInfoCount > 0;
    }

    @NotNull
    public List<ClassifierSet> getChildrenClassifierSets() {
        this.ensurePartition();
        assert (this.myClassifier != null);
        return this.myClassifier.getClassifierSets();
    }

    @Nullable
    public ClassifierSet findContainingClassifierSet(@NotNull InstanceObject target) {
        boolean instancesContainsTarget = this.myInstances.contains(target);
        if (instancesContainsTarget && this.myClassifier != null) {
            return this;
        }
        if (instancesContainsTarget || this.myClassifier != null) {
            List<ClassifierSet> childrenClassifierSets = this.getChildrenClassifierSets();
            if (instancesContainsTarget && this.myInstances.contains(target)) {
                return this;
            }
            for (ClassifierSet set : childrenClassifierSets) {
                ClassifierSet result = set.findContainingClassifierSet(target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isSupersetOf(@NotNull ClassifierSet targetSet) {
        if (this.getInstancesCount() < targetSet.getInstancesCount()) {
            return false;
        }
        Set instances = this.getInstancesStream().collect(Collectors.toSet());
        return targetSet.getInstancesStream().allMatch(instances::contains);
    }

    protected void ensurePartition() {
        if (this.myClassifier == null) {
            this.myClassifier = this.createSubClassifier();
            this.myClassifier.partition(this.myInstances);
        }
    }

    @NotNull
    protected abstract Classifier createSubClassifier();

    public static abstract class Classifier {
        public static final Classifier IDENTITY_CLASSIFIER = new Classifier(){

            @Override
            public boolean isTerminalClassifier() {
                return true;
            }

            @Override
            @NotNull
            public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
                throw new NotImplementedException();
            }

            @Override
            @NotNull
            public List<ClassifierSet> getClassifierSets() {
                return Collections.emptyList();
            }
        };

        public boolean isTerminalClassifier() {
            return false;
        }

        @NotNull
        public abstract ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject var1);

        @NotNull
        public abstract List<ClassifierSet> getClassifierSets();

        public final void partition(@NotNull Set<InstanceObject> instances) {
            ArrayList partitionedInstances = new ArrayList(instances.size());
            if (!this.isTerminalClassifier()) {
                instances.forEach(instance -> {
                    if (instance.hasTimeData()) {
                        if (instance.hasAllocData()) {
                            this.getOrCreateClassifierSet((InstanceObject)instance).addInstanceObject((InstanceObject)instance);
                        }
                        if (instance.hasDeallocData()) {
                            this.getOrCreateClassifierSet((InstanceObject)instance).freeInstanceObject((InstanceObject)instance);
                        }
                        partitionedInstances.add(instance);
                    } else {
                        this.getOrCreateClassifierSet((InstanceObject)instance).addInstanceObject((InstanceObject)instance);
                        partitionedInstances.add(instance);
                    }
                });
            }
            if (partitionedInstances.size() == instances.size()) {
                instances.clear();
            } else {
                instances.removeAll(partitionedInstances);
            }
        }
    }
}

