/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.PackageSet;
import com.android.tools.profilers.memory.adapters.ThreadSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class HeapSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private MemoryProfilerConfiguration.ClassGrouping myClassGrouping = MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS;
    private final int myId;

    public HeapSet(@NotNull CaptureObject captureObject, @NotNull String heapName, int id) {
        super(heapName);
        this.myCaptureObject = captureObject;
        this.myId = id;
        this.setClassGrouping(MemoryProfilerConfiguration.ClassGrouping.ARRANGE_BY_CLASS);
    }

    public void setClassGrouping(@NotNull MemoryProfilerConfiguration.ClassGrouping classGrouping) {
        if (this.myClassGrouping == classGrouping) {
            return;
        }
        this.myClassGrouping = classGrouping;
        List descendantsStream = this.getInstancesStream().collect(Collectors.toList());
        this.myInstances.clear();
        this.myClassifier = null;
        this.myInstances.addAll(descendantsStream);
    }

    public int getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        switch (this.myClassGrouping) {
            case ARRANGE_BY_CLASS: {
                return ClassSet.createDefaultClassifier();
            }
            case ARRANGE_BY_PACKAGE: {
                return PackageSet.createDefaultClassifier(this.myCaptureObject);
            }
            case ARRANGE_BY_CALLSTACK: {
                return ThreadSet.createDefaultClassifier(this.myCaptureObject);
            }
        }
        throw new RuntimeException("Classifier type not implemented: " + (Object)((Object)this.myClassGrouping));
    }
}

