/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.RelativeTimeConverter;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LegacyAllocationsInstanceObject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LegacyAllocationCaptureObject
implements CaptureObject {
    static final int DEFAULT_HEAP_ID = 0;
    static final String DEFAULT_HEAP_NAME = "default";
    static final long DEFAULT_CLASSLOADER_ID = -1L;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final ClassDb myClassDb;
    @NotNull
    private final String myLabel;
    private final int myProcessId;
    private final Common.Session mySession;
    private long myStartTimeNs;
    private long myEndTimeNs;
    private final FeatureTracker myFeatureTracker;
    private volatile boolean myIsDoneLoading = false;
    private volatile boolean myIsLoadingError = false;
    private final HeapSet myFakeHeapSet;

    public LegacyAllocationCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @Nullable Common.Session session, int processId, @NotNull MemoryProfiler.AllocationsInfo info, @NotNull RelativeTimeConverter converter, @NotNull FeatureTracker featureTracker) {
        this.myClient = client;
        this.myClassDb = new ClassDb();
        this.myProcessId = processId;
        this.mySession = session;
        this.myStartTimeNs = info.getStartTime();
        this.myEndTimeNs = info.getEndTime();
        this.myFakeHeapSet = new HeapSet(this, DEFAULT_HEAP_NAME, 0);
        this.myLabel = "Allocations" + (this.myStartTimeNs != Long.MAX_VALUE ? " from " + TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(converter.convertToRelativeTime(this.myStartTimeNs))) : "") + (this.myEndTimeNs != Long.MIN_VALUE ? " to " + TimeAxisFormatter.DEFAULT.getFixedPointFormattedString(TimeUnit.MILLISECONDS.toMicros(1L), TimeUnit.NANOSECONDS.toMicros(converter.convertToRelativeTime(this.myEndTimeNs))) : "");
        this.myFeatureTracker = featureTracker;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myLabel;
    }

    @Override
    public boolean isExportable() {
        return true;
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return "alloc";
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        MemoryProfiler.DumpDataResponse response = this.myClient.getLegacyAllocationDump(MemoryProfiler.DumpDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setDumpTime(this.myStartTimeNs).build());
        if (response.getStatus() != MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            throw new IOException("Could not retrieve allocation dump.");
        }
        response.getData().writeTo(outputStream);
        this.myFeatureTracker.trackExportAllocation();
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        assert (this.isDoneLoading() && !this.isError());
        return this.myFakeHeapSet.getInstancesStream();
    }

    @Override
    public long getStartTimeNs() {
        return this.myStartTimeNs;
    }

    @Override
    public long getEndTimeNs() {
        return this.myEndTimeNs;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        MemoryProfiler.LegacyAllocationEventsResponse response;
        while ((response = this.myClient.getLegacyAllocationEvents(MemoryProfiler.LegacyAllocationEventsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(this.myStartTimeNs).setEndTime(this.myEndTimeNs).build())).getStatus() != MemoryProfiler.LegacyAllocationEventsResponse.Status.SUCCESS) {
            if (response.getStatus() == MemoryProfiler.LegacyAllocationEventsResponse.Status.NOT_READY) {
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.myIsLoadingError = true;
                    return false;
                }
            }
            this.myIsLoadingError = true;
            return false;
        }
        MemoryProfiler.LegacyAllocationContextsRequest contextRequest = MemoryProfiler.LegacyAllocationContextsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).addAllStackIds((Iterable)response.getEventsList().stream().map(MemoryProfiler.LegacyAllocationEvent::getStackId).collect(Collectors.toSet())).addAllClassIds((Iterable)response.getEventsList().stream().map(MemoryProfiler.LegacyAllocationEvent::getClassId).collect(Collectors.toSet())).build();
        MemoryProfiler.AllocationContextsResponse contextsResponse = this.myClient.getLegacyAllocationContexts(contextRequest);
        HashMap classEntryMap = new HashMap();
        HashMap callStacks = new HashMap();
        contextsResponse.getAllocatedClassesList().forEach(className -> classEntryMap.put(className.getClassId(), this.myClassDb.registerClass(-1L, className.getClassName())));
        contextsResponse.getAllocationStacksList().forEach(callStack -> callStacks.putIfAbsent(callStack.getStackId(), callStack));
        for (MemoryProfiler.LegacyAllocationEvent event : response.getEventsList()) {
            assert (classEntryMap.containsKey(event.getClassId()));
            assert (callStacks.containsKey(event.getStackId()));
            this.myFakeHeapSet.addInstanceObject(new LegacyAllocationsInstanceObject(event, (ClassDb.ClassEntry)classEntryMap.get(event.getClassId()), (MemoryProfiler.AllocationStack)callStacks.get(event.getStackId())));
        }
        this.myIsDoneLoading = true;
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return this.myIsDoneLoading || this.myIsLoadingError;
    }

    @Override
    public boolean isError() {
        return this.myIsLoadingError;
    }

    @Override
    public void unload() {
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return Arrays.asList(CaptureObject.ClassifierAttribute.LABEL, CaptureObject.ClassifierAttribute.ALLOC_COUNT, CaptureObject.ClassifierAttribute.SHALLOW_SIZE);
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return Arrays.asList(CaptureObject.InstanceAttribute.LABEL, CaptureObject.InstanceAttribute.SHALLOW_SIZE);
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return Collections.singletonList(this.myFakeHeapSet);
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId == 0);
        return this.myFakeHeapSet;
    }
}

