/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationInstanceObject;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.openapi.diagnostic.Logger;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LiveAllocationCaptureObject
implements CaptureObject {
    static final String DEFAULT_HEAP_NAME = "default";
    static final String IMAGE_HEAP_NAME = "image";
    static final String ZYGOTE_HEAP_NAME = "zygote";
    static final String APP_HEAP_NAME = "app";
    @Nullable
    private MemoryProfilerStage myStage;
    final ExecutorService myExecutorService;
    private final ClassDb myClassDb;
    private final Map<ClassDb.ClassEntry, LiveAllocationInstanceObject> myClassMap;
    private final TIntObjectHashMap<LiveAllocationInstanceObject> myInstanceMap;
    private final TIntObjectHashMap<MemoryProfiler.AllocationStack> myCallstackMap;
    private final TIntObjectHashMap<ThreadId> myThreadIdMap;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final Common.Session mySession;
    private final int myProcessId;
    private final long myCaptureStartTime;
    private final List<HeapSet> myHeapSets;
    private final AspectObserver myAspectObserver;
    private long myEventsEndTimeNs;
    private long myContextEndTimeNs;
    private long myPreviousQueryStartTimeNs;
    private long myPreviousQueryEndTimeNs;
    private Range myQueryRange;
    private Future myCurrentTask;

    private static Logger getLogger() {
        return Logger.getInstance(LiveAllocationCaptureObject.class);
    }

    public LiveAllocationCaptureObject(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @Nullable Common.Session session, int processId, long captureStartTime, @Nullable ExecutorService loadService, @Nullable MemoryProfilerStage stage) {
        this.myExecutorService = loadService == null ? Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("profiler-live-allocation").build()) : loadService;
        this.myClassDb = new ClassDb();
        this.myClassMap = new HashMap<ClassDb.ClassEntry, LiveAllocationInstanceObject>();
        this.myInstanceMap = new TIntObjectHashMap();
        this.myCallstackMap = new TIntObjectHashMap();
        this.myThreadIdMap = new TIntObjectHashMap();
        this.myClient = client;
        this.mySession = session;
        this.myProcessId = processId;
        this.myCaptureStartTime = captureStartTime;
        this.myAspectObserver = new AspectObserver();
        this.myStage = stage;
        this.myHeapSets = Arrays.asList(new HeapSet(this, DEFAULT_HEAP_NAME, 0), new HeapSet(this, IMAGE_HEAP_NAME, 1), new HeapSet(this, ZYGOTE_HEAP_NAME, 2), new HeapSet(this, APP_HEAP_NAME, 3));
        this.myEventsEndTimeNs = Long.MIN_VALUE;
        this.myContextEndTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryStartTimeNs = Long.MIN_VALUE;
        this.myPreviousQueryEndTimeNs = Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public Common.Session getSession() {
        return this.mySession;
    }

    @Override
    public int getProcessId() {
        return this.myProcessId;
    }

    @Override
    @NotNull
    public MemoryServiceGrpc.MemoryServiceBlockingStub getClient() {
        return this.myClient;
    }

    @Override
    @NotNull
    public String getName() {
        return "Live Allocation";
    }

    @Override
    @Nullable
    public String getExportableExtension() {
        return null;
    }

    @Override
    public void saveToFile(@NotNull OutputStream outputStream) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    @NotNull
    public List<CaptureObject.ClassifierAttribute> getClassifierAttributes() {
        return ImmutableList.of((Object)((Object)CaptureObject.ClassifierAttribute.LABEL), (Object)((Object)CaptureObject.ClassifierAttribute.ALLOC_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.DEALLOC_COUNT), (Object)((Object)CaptureObject.ClassifierAttribute.SHALLOW_SIZE));
    }

    @Override
    @NotNull
    public List<CaptureObject.InstanceAttribute> getInstanceAttributes() {
        return ImmutableList.of((Object)((Object)CaptureObject.InstanceAttribute.LABEL), (Object)((Object)CaptureObject.InstanceAttribute.ALLOCATION_TIME), (Object)((Object)CaptureObject.InstanceAttribute.DEALLOCATION_TIME));
    }

    @Override
    @NotNull
    public Collection<HeapSet> getHeapSets() {
        return this.myHeapSets;
    }

    @Override
    @Nullable
    public HeapSet getHeapSet(int heapId) {
        assert (heapId >= 0 && heapId <= 3);
        return this.myHeapSets.get(heapId);
    }

    @Override
    @NotNull
    public Stream<InstanceObject> getInstances() {
        return this.getHeapSets().stream().map(ClassifierSet::getInstancesStream).flatMap(Function.identity());
    }

    @Override
    public long getStartTimeNs() {
        return this.myCaptureStartTime;
    }

    @Override
    public long getEndTimeNs() {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean load(@Nullable Range queryRange, @Nullable Executor queryJoiner) {
        assert (queryRange != null);
        assert (queryJoiner != null);
        this.myQueryRange = queryRange;
        this.myQueryRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, () -> this.loadTimeRange(this.myQueryRange, queryJoiner));
        this.loadTimeRange(this.myQueryRange, queryJoiner);
        return true;
    }

    @Override
    public boolean isDoneLoading() {
        return true;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public void unload() {
        this.myQueryRange.removeDependencies(this.myAspectObserver);
        this.myExecutorService.shutdownNow();
    }

    private void updateAllocationContexts(long endTimeNs) {
        if (this.myContextEndTimeNs >= endTimeNs) {
            return;
        }
        MemoryProfiler.AllocationContextsResponse contextsResponse = this.myClient.getAllocationContexts(MemoryProfiler.AllocationContextsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(this.myContextEndTimeNs).setEndTime(endTimeNs).build());
        for (MemoryProfiler.AllocatedClass klass : contextsResponse.getAllocatedClassesList()) {
            ClassDb.ClassEntry entry = this.myClassDb.registerClass(-1L, klass.getClassName(), klass.getClassId());
            if (this.myClassMap.containsKey(entry)) continue;
            LiveAllocationInstanceObject instance = new LiveAllocationInstanceObject(this, entry, null, null, null, -1L, -1);
            instance.setAllocationTime(this.myCaptureStartTime);
            this.myClassMap.put(entry, instance);
        }
        contextsResponse.getAllocationStacksList().forEach(callStack -> {
            if (!this.myCallstackMap.contains(callStack.getStackId())) {
                this.myCallstackMap.put(callStack.getStackId(), callStack);
            }
        });
        contextsResponse.getAllocationThreadsList().forEach(thread -> {
            if (!this.myThreadIdMap.contains(thread.getThreadId())) {
                this.myThreadIdMap.put(thread.getThreadId(), (Object)new ThreadId(thread.getThreadName()));
            }
        });
        this.myContextEndTimeNs = Math.max(this.myContextEndTimeNs, contextsResponse.getTimestamp());
    }

    private void loadTimeRange(@NotNull Range queryRange, @NotNull Executor joiner) {
        try {
            if (this.myCurrentTask != null) {
                this.myCurrentTask.cancel(false);
            }
            this.myCurrentTask = this.myExecutorService.submit(() -> {
                boolean clear;
                long newStartTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMin());
                long newEndTimeNs = TimeUnit.MICROSECONDS.toNanos((long)queryRange.getMax());
                if (newStartTimeNs == this.myPreviousQueryStartTimeNs && newEndTimeNs == this.myPreviousQueryEndTimeNs && newEndTimeNs != Long.MAX_VALUE) {
                    return null;
                }
                joiner.execute(() -> this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATING));
                this.updateAllocationContexts(newEndTimeNs);
                if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                    MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(this.myEventsEndTimeNs + 1L).setEndTime(newEndTimeNs).build());
                    this.myEventsEndTimeNs = Math.max(this.myEventsEndTimeNs, sampleResponse.getTimestamp());
                    if (newEndTimeNs > this.myEventsEndTimeNs + 1L) {
                        newEndTimeNs = this.myEventsEndTimeNs + 1L;
                        newStartTimeNs = Math.min(newStartTimeNs, newEndTimeNs);
                    }
                }
                long[] timestamps = new long[]{this.myPreviousQueryStartTimeNs, this.myPreviousQueryEndTimeNs, newStartTimeNs, newEndTimeNs};
                boolean bl = clear = this.myPreviousQueryEndTimeNs <= newStartTimeNs || newEndTimeNs <= this.myPreviousQueryStartTimeNs;
                if (clear) {
                    long[] newTimeStamps = new long[]{newStartTimeNs, newEndTimeNs};
                    timestamps = newTimeStamps;
                    this.myInstanceMap.clear();
                }
                Arrays.sort(timestamps);
                ArrayList<LiveAllocationInstanceObject> setAllocationList = new ArrayList<LiveAllocationInstanceObject>();
                ArrayList<LiveAllocationInstanceObject> resetAllocationList = new ArrayList<LiveAllocationInstanceObject>();
                ArrayList<LiveAllocationInstanceObject> setDeallocationList = new ArrayList<LiveAllocationInstanceObject>();
                ArrayList<LiveAllocationInstanceObject> resetDeallocationList = new ArrayList<LiveAllocationInstanceObject>();
                int stampNumber = 0;
                while (stampNumber + 1 < timestamps.length) {
                    long startTimeNs = timestamps[stampNumber];
                    long endTimeNs = timestamps[stampNumber + 1];
                    if (startTimeNs != endTimeNs) {
                        boolean insideCurrentRange;
                        boolean insidePreviousRange = startTimeNs >= this.myPreviousQueryStartTimeNs && endTimeNs <= this.myPreviousQueryEndTimeNs;
                        boolean bl2 = insideCurrentRange = startTimeNs >= newStartTimeNs && endTimeNs <= newEndTimeNs;
                        if (insidePreviousRange != insideCurrentRange) {
                            MemoryProfiler.BatchAllocationSample sampleResponse = this.myClient.getAllocations(MemoryProfiler.AllocationSnapshotRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTime(startTimeNs).setEndTime(endTimeNs).build());
                            for (MemoryProfiler.AllocationEvent event : sampleResponse.getEventsList()) {
                                LiveAllocationInstanceObject instance;
                                if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.ALLOC_DATA) {
                                    MemoryProfiler.AllocationEvent.Allocation allocation = event.getAllocData();
                                    instance = this.getOrCreateInstanceObject(allocation.getTag(), allocation.getClassTag(), allocation.getStackId(), allocation.getThreadId(), allocation.getSize(), allocation.getHeapId());
                                    if (insideCurrentRange) {
                                        instance.setAllocationTime(event.getTimestamp());
                                        setAllocationList.add(instance);
                                        continue;
                                    }
                                    instance.setAllocationTime(Long.MIN_VALUE);
                                    resetAllocationList.add(instance);
                                    continue;
                                }
                                if (event.getEventCase() == MemoryProfiler.AllocationEvent.EventCase.FREE_DATA) {
                                    MemoryProfiler.AllocationEvent.Deallocation deallocation = event.getFreeData();
                                    instance = this.getOrCreateInstanceObject(deallocation.getTag(), deallocation.getClassTag(), deallocation.getStackId(), deallocation.getThreadId(), deallocation.getSize(), deallocation.getHeapId());
                                    if (insideCurrentRange) {
                                        instance.setDeallocTime(event.getTimestamp());
                                        setDeallocationList.add(instance);
                                        continue;
                                    }
                                    instance.setDeallocTime(Long.MAX_VALUE);
                                    resetDeallocationList.add(instance);
                                    continue;
                                }
                                assert (false);
                            }
                        }
                    }
                    ++stampNumber;
                }
                this.myPreviousQueryStartTimeNs = newStartTimeNs;
                this.myPreviousQueryEndTimeNs = newEndTimeNs;
                joiner.execute(() -> {
                    this.myStage.getAspect().changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_UPDATED);
                    if (clear || setAllocationList.size() + setDeallocationList.size() + resetAllocationList.size() + resetDeallocationList.size() > 0) {
                        if (clear) {
                            this.myHeapSets.forEach(heap -> heap.clearClassifierSets());
                            if (this.myStage.getSelectedClassSet() != null) {
                                this.myStage.selectClassSet(ClassSet.EMPTY_SET);
                            }
                        }
                        setAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).addInstanceObject((InstanceObject)instance));
                        setDeallocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).freeInstanceObject((InstanceObject)instance));
                        resetAllocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeAddingInstanceObject((InstanceObject)instance));
                        resetDeallocationList.forEach(instance -> this.myHeapSets.get(instance.getHeapId()).removeFreeingInstanceObject((InstanceObject)instance));
                        this.myStage.refreshSelectedHeap();
                    }
                });
                return null;
            });
        }
        catch (RejectedExecutionException e) {
            LiveAllocationCaptureObject.getLogger().debug((Throwable)e);
        }
    }

    @NotNull
    private LiveAllocationInstanceObject getOrCreateInstanceObject(int tag, int classTag, int stackId, int threadId, long size, int heapId) {
        LiveAllocationInstanceObject instance = (LiveAllocationInstanceObject)this.myInstanceMap.get(tag);
        if (instance == null) {
            ClassDb.ClassEntry entry = this.myClassDb.getEntry(classTag);
            assert (this.myClassMap.containsKey(entry));
            MemoryProfiler.AllocationStack callstack = null;
            if (stackId != 0) {
                assert (this.myCallstackMap.containsKey(stackId));
                callstack = (MemoryProfiler.AllocationStack)this.myCallstackMap.get(stackId);
            }
            ThreadId thread = null;
            if (threadId != 0) {
                assert (this.myThreadIdMap.containsKey(threadId));
                thread = (ThreadId)this.myThreadIdMap.get(threadId);
            }
            instance = new LiveAllocationInstanceObject(this, entry, this.myClassMap.get(entry), thread, callstack, size, heapId);
            this.myInstanceMap.put(tag, (Object)instance);
        }
        return instance;
    }
}

