/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject myCaptureObject;
    @NotNull
    private final ClassDb.ClassEntry myClassEntry;
    @Nullable
    private final LiveAllocationInstanceObject myClassObject;
    @NotNull
    private final ValueObject.ValueType myValueType;
    private long myAllocTime = Long.MIN_VALUE;
    private long myDeallocTime = Long.MAX_VALUE;
    private final long mySize;
    private final int myHeapId;
    @Nullable
    private MemoryProfiler.AllocationStack myCallstack;
    @Nullable
    private final ThreadId myThreadId;

    public LiveAllocationInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull ClassDb.ClassEntry classEntry, @Nullable LiveAllocationInstanceObject classObject, @Nullable ThreadId threadId, @Nullable MemoryProfiler.AllocationStack callstack, long size, int heapId) {
        this.myCaptureObject = captureObject;
        this.myClassEntry = classEntry;
        this.myClassObject = classObject;
        this.mySize = size;
        this.myHeapId = heapId;
        this.myThreadId = threadId == null ? ThreadId.INVALID_THREAD_ID : threadId;
        this.myCallstack = callstack;
        this.myValueType = "java.lang.String".equals(classEntry.getClassName()) ? ValueObject.ValueType.STRING : (classEntry.getClassName().endsWith("[]") ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT);
    }

    @Override
    public long getAllocTime() {
        return this.myAllocTime;
    }

    public void setDeallocTime(long deallocTime) {
        this.myDeallocTime = deallocTime;
    }

    public void setAllocationTime(long allocTime) {
        this.myAllocTime = allocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.myDeallocTime;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocData() || this.hasDeallocData();
    }

    @Override
    public boolean hasAllocData() {
        return this.myAllocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocData() {
        return this.myDeallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return this.myHeapId;
    }

    @Override
    public int getShallowSize() {
        return (int)this.mySize;
    }

    @Override
    @Nullable
    public MemoryProfiler.AllocationStack getCallStack() {
        return this.myCallstack;
    }

    @Override
    @NotNull
    public List<CodeLocation> getCodeLocations() {
        ArrayList<CodeLocation> codeLocations = new ArrayList<CodeLocation>();
        if (this.myCallstack != null && this.myCallstack.getFrameCase() == MemoryProfiler.AllocationStack.FrameCase.SMALL_STACK) {
            MemoryProfiler.AllocationStack.SmallFrameWrapper smallFrames = this.myCallstack.getSmallStack();
            for (MemoryProfiler.AllocationStack.SmallFrame frame : smallFrames.getFramesList()) {
                MemoryProfiler.StackFrameInfoResponse frameInfo = this.myCaptureObject.getClient().getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest.newBuilder().setProcessId(this.myCaptureObject.getProcessId()).setSession(this.myCaptureObject.getSession()).setMethodId(frame.getMethodId()).build());
                CodeLocation.Builder builder = new CodeLocation.Builder(frameInfo.getClassName()).setMethodName(frameInfo.getMethodName()).setLineNumber(frame.getLineNumber() - 1);
                codeLocations.add(builder.build());
            }
        }
        return codeLocations;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.myClassEntry;
    }

    @Override
    @Nullable
    public InstanceObject getClassObject() {
        return this.myClassObject;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.myValueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        return this.myClassEntry.getSimpleClassName();
    }
}

