/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSet
extends ClassifierSet {
    @NotNull
    private final MethodSetInfo myMethodInfo;
    @NotNull
    private final CaptureObject myCaptureObject;
    private final int myCallstackDepth;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return new MethodClassifier(captureObject, 0);
    }

    public MethodSet(@NotNull CaptureObject captureObject, @NotNull MethodSetInfo methodInfo, int callstackDepth) {
        super(() -> methodInfo.getName());
        this.myCaptureObject = captureObject;
        this.myMethodInfo = methodInfo;
        this.myCallstackDepth = callstackDepth;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        return new MethodClassifier(this.myCaptureObject, this.myCallstackDepth);
    }

    @NotNull
    public String getClassName() {
        return this.myMethodInfo.getClassName();
    }

    @NotNull
    public String getMethodName() {
        return this.myMethodInfo.getMethodName();
    }

    private static final class MethodSetInfo {
        static final long INVALID_METHOD_ID = -1L;
        @NotNull
        private final CaptureObject myCaptureObject;
        private long myMethodId;
        @Nullable
        private String myClassName;
        @Nullable
        private String myMethodName;
        private boolean myResolvedNames;
        private int myHashCode;

        MethodSetInfo(@NotNull CaptureObject captureObject, @NotNull String className, @NotNull String methodName) {
            this.myCaptureObject = captureObject;
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodId = -1L;
            this.myHashCode = Arrays.hashCode(new int[]{this.myClassName.hashCode(), this.myMethodName.hashCode()});
            this.myResolvedNames = true;
        }

        MethodSetInfo(@NotNull CaptureObject captureObject, long methodId) {
            this.myCaptureObject = captureObject;
            this.myMethodId = methodId;
            this.myHashCode = Long.hashCode(this.myMethodId);
            this.myResolvedNames = false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSetInfo)) {
                return false;
            }
            MethodSetInfo other = (MethodSetInfo)obj;
            if (this.myMethodId == -1L) {
                return StringUtil.equals((CharSequence)this.myClassName, (CharSequence)other.myClassName) && StringUtil.equals((CharSequence)this.myMethodName, (CharSequence)other.myMethodName);
            }
            return this.myMethodId == other.myMethodId;
        }

        @NotNull
        String getName() {
            this.resolveNames();
            StringBuilder builder = new StringBuilder();
            if (this.myMethodName != null) {
                builder.append(this.myMethodName).append("()");
            } else {
                builder.append("<unknown method>");
            }
            builder.append(" (").append(this.myClassName).append(")");
            return builder.toString();
        }

        @NotNull
        String getClassName() {
            this.resolveNames();
            return this.myClassName;
        }

        @NotNull
        String getMethodName() {
            this.resolveNames();
            return this.myMethodName;
        }

        private void resolveNames() {
            if (this.myResolvedNames) {
                return;
            }
            assert (this.myMethodId != -1L);
            MemoryProfiler.StackFrameInfoResponse frameInfo = this.myCaptureObject.getClient().getStackFrameInfo(MemoryProfiler.StackFrameInfoRequest.newBuilder().setProcessId(this.myCaptureObject.getProcessId()).setSession(this.myCaptureObject.getSession()).setMethodId(this.myMethodId).build());
            this.myClassName = frameInfo.getClassName();
            this.myMethodName = frameInfo.getMethodName();
            this.myResolvedNames = true;
        }
    }

    private static final class MethodClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<MethodSetInfo, MethodSet> myStackLineMap = new LinkedHashMap<MethodSetInfo, MethodSet>();
        @NotNull
        private final Map<ClassDb.ClassEntry, ClassSet> myClassMap = new LinkedHashMap<ClassDb.ClassEntry, ClassSet>();
        private final int myDepth;

        private MethodClassifier(@NotNull CaptureObject captureObject, int depth) {
            this.myCaptureObject = captureObject;
            this.myDepth = depth;
        }

        @Override
        @NotNull
        public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
            MemoryProfiler.AllocationStack stack = instance.getCallStack();
            int stackDepth = instance.getCallStackDepth();
            if (stack != null && stackDepth > 0 && this.myDepth < stackDepth) {
                switch (stack.getFrameCase()) {
                    case FULL_STACK: {
                        MemoryProfiler.AllocationStack.StackFrameWrapper fullStack = stack.getFullStack();
                        MemoryProfiler.AllocationStack.StackFrame stackFrame = fullStack.getFrames(fullStack.getFramesCount() - this.myDepth - 1);
                        MethodSetInfo fullMethodInfo = new MethodSetInfo(this.myCaptureObject, stackFrame.getClassName(), stackFrame.getMethodName());
                        return this.myStackLineMap.computeIfAbsent(fullMethodInfo, info -> new MethodSet(this.myCaptureObject, (MethodSetInfo)info, this.myDepth + 1));
                    }
                    case SMALL_STACK: {
                        MemoryProfiler.AllocationStack.SmallFrameWrapper smallStack = stack.getSmallStack();
                        MemoryProfiler.AllocationStack.SmallFrame smallFrame = smallStack.getFrames(smallStack.getFramesCount() - this.myDepth - 1);
                        MethodSetInfo lazyMethodInfo = new MethodSetInfo(this.myCaptureObject, smallFrame.getMethodId());
                        return this.myStackLineMap.computeIfAbsent(lazyMethodInfo, info -> new MethodSet(this.myCaptureObject, (MethodSetInfo)info, this.myDepth + 1));
                    }
                }
            }
            return this.myClassMap.computeIfAbsent(instance.getClassEntry(), ClassSet::new);
        }

        @Override
        @NotNull
        public List<ClassifierSet> getClassifierSets() {
            return Stream.concat(this.myStackLineMap.values().stream(), this.myClassMap.values().stream()).filter(child -> !child.isEmpty()).collect(Collectors.toList());
        }
    }
}

