/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassifierSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.MethodSet;
import com.android.tools.profilers.stacktrace.ThreadId;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ThreadSet
extends ClassifierSet {
    @NotNull
    private final CaptureObject myCaptureObject;
    @NotNull
    private final ThreadId myThreadId;

    @NotNull
    public static ClassifierSet.Classifier createDefaultClassifier(@NotNull CaptureObject captureObject) {
        return new ThreadClassifier(captureObject);
    }

    public ThreadSet(@NotNull CaptureObject captureObject, @NotNull ThreadId threadId) {
        super(threadId.toString());
        this.myCaptureObject = captureObject;
        this.myThreadId = threadId;
    }

    @NotNull
    public ThreadId getThreadId() {
        return this.myThreadId;
    }

    @Override
    @NotNull
    public ClassifierSet.Classifier createSubClassifier() {
        return MethodSet.createDefaultClassifier(this.myCaptureObject);
    }

    private static final class ThreadClassifier
    extends ClassifierSet.Classifier {
        @NotNull
        private final CaptureObject myCaptureObject;
        @NotNull
        private final Map<ThreadId, ThreadSet> myThreadSets = new LinkedHashMap<ThreadId, ThreadSet>();
        @NotNull
        private final ClassifierSet.Classifier myMethodSetClassifier;

        private ThreadClassifier(@NotNull CaptureObject captureObject) {
            this.myCaptureObject = captureObject;
            this.myMethodSetClassifier = MethodSet.createDefaultClassifier(this.myCaptureObject);
        }

        @Override
        @NotNull
        public ClassifierSet getOrCreateClassifierSet(@NotNull InstanceObject instance) {
            if (instance.getAllocationThreadId() != ThreadId.INVALID_THREAD_ID) {
                return this.myThreadSets.computeIfAbsent(instance.getAllocationThreadId(), threadId -> new ThreadSet(this.myCaptureObject, (ThreadId)threadId));
            }
            return this.myMethodSetClassifier.getOrCreateClassifierSet(instance);
        }

        @Override
        @NotNull
        public List<ClassifierSet> getClassifierSets() {
            return Stream.concat(this.myThreadSets.values().stream(), this.myMethodSetClassifier.getClassifierSets().stream()).filter(child -> !child.isEmpty()).collect(Collectors.toList());
        }
    }
}

