/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.FlatTabbedPane;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendConfig;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.legend.FixedLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.profilers.CloseButton;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.android.tools.profilers.network.NetworkState;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.collect.ImmutableMap;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.BoldLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionDetailsView
extends JPanel {
    private static final String TAB_TITLE_RESPONSE = "Response";
    private static final String TAB_TITLE_STACK = "Call Stack";
    private static final String TAB_TITLE_HEADERS = "Headers";
    private static final int PAGE_VGAP = JBUI.scale((int)28);
    private static final int SECTION_VGAP = JBUI.scale((int)10);
    private static final int HGAP = JBUI.scale((int)22);
    private static final int SCROLL_UNIT = JBUI.scale((int)10);
    private static final float TITLE_FONT_SIZE = 14.0f;
    private static final float FIELD_FONT_SIZE = 11.0f;
    private static final LongFunction<String> TIME_FORMATTER = time -> time >= 0L ? StringUtil.formatDuration((long)TimeUnit.MICROSECONDS.toMillis(time)) : "*";
    @NotNull
    private final JPanel myResponsePanel;
    @NotNull
    private final JPanel myHeadersPanel;
    @NotNull
    private final StackTraceView myStackTraceView;
    @NotNull
    private final NetworkProfilerStageView myStageView;
    @NotNull
    private final FlatTabbedPane myTabsPanel;

    public ConnectionDetailsView(@NotNull NetworkProfilerStageView stageView) {
        super(new BorderLayout());
        this.myStageView = stageView;
        JPanel rootPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit", "Fit,*"));
        this.myTabsPanel = new FlatTabbedPane();
        this.myTabsPanel.getTabAreaInsets().top = -1;
        final TabularLayout layout = new TabularLayout("*").setVGap(PAGE_VGAP);
        this.myResponsePanel = new JPanel((LayoutManager)layout);
        this.myResponsePanel.setBorder(BorderFactory.createEmptyBorder(PAGE_VGAP, HGAP, 0, HGAP));
        this.myResponsePanel.setName(TAB_TITLE_RESPONSE);
        final JBScrollPane responseScroll = new JBScrollPane((Component)this.myResponsePanel, 20, 31);
        responseScroll.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        responseScroll.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                layout.setRowSizing(0, new TabularLayout.SizingRule(TabularLayout.SizingRule.Type.FIXED, (int)((float)responseScroll.getViewport().getHeight() * 0.4f)));
                layout.layoutContainer((Container)ConnectionDetailsView.this.myResponsePanel);
            }
        });
        responseScroll.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        this.myTabsPanel.addTab(TAB_TITLE_RESPONSE, (Component)responseScroll);
        this.myHeadersPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, PAGE_VGAP));
        this.myHeadersPanel.setName(TAB_TITLE_HEADERS);
        JBScrollPane headersScroll = new JBScrollPane((Component)this.myHeadersPanel);
        headersScroll.getVerticalScrollBar().setUnitIncrement(SCROLL_UNIT);
        headersScroll.getHorizontalScrollBar().setUnitIncrement(SCROLL_UNIT);
        headersScroll.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        this.myTabsPanel.addTab(TAB_TITLE_HEADERS, (Component)headersScroll);
        this.myStackTraceView = this.myStageView.getIdeComponents().createStackView(((NetworkProfilerStage)stageView.getStage()).getStackTraceModel());
        this.myStackTraceView.getComponent().setName("StackTrace");
        JComponent stackTraceComponent = this.myStackTraceView.getComponent();
        stackTraceComponent.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        this.myTabsPanel.addTab(TAB_TITLE_STACK, (Component)stackTraceComponent);
        this.myTabsPanel.addChangeListener(e -> {
            this.repaint();
            this.trackActiveTab();
        });
        CloseButton closeButton = new CloseButton(e -> ((NetworkProfilerStage)this.myStageView.getStage()).setSelectedConnection(null));
        rootPanel.add((Component)((Object)closeButton), new TabularLayout.Constraint(0, 1));
        rootPanel.add((Component)this.myTabsPanel, new TabularLayout.Constraint(0, 0, 2, 2));
        this.add(rootPanel);
    }

    private void trackActiveTab() {
        if (this.myTabsPanel.getSelectedIndex() < 0) {
            return;
        }
        FeatureTracker featureTracker = ((NetworkProfilerStage)this.myStageView.getStage()).getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (this.myTabsPanel.getTitleAt(this.myTabsPanel.getSelectedIndex())) {
            case "Response": {
                featureTracker.trackSelectNetworkDetailsResponse();
                break;
            }
            case "Headers": {
                featureTracker.trackSelectNetworkDetailsHeaders();
                break;
            }
            case "Call Stack": {
                featureTracker.trackSelectNetworkDetailsStack();
                break;
            }
        }
    }

    public void setHttpData(@Nullable HttpData httpData) {
        this.setBackground(JBColor.background());
        this.myResponsePanel.removeAll();
        this.myHeadersPanel.removeAll();
        if (httpData != null) {
            Optional<File> payloadFile = Optional.ofNullable(httpData.getResponsePayloadFile());
            DataViewer fileViewer = this.myStageView.getIdeComponents().createFileViewer(payloadFile.orElse(new File("")));
            fileViewer.getComponent().setName("FileViewer");
            this.myResponsePanel.add((Component)fileViewer.getComponent(), new TabularLayout.Constraint(0, 0));
            this.myResponsePanel.add((Component)ConnectionDetailsView.createFields(httpData, fileViewer.getDimension()), new TabularLayout.Constraint(1, 0));
            this.myHeadersPanel.add(ConnectionDetailsView.createHeaderSection("Response Headers", httpData.getResponseHeaders()));
            this.myHeadersPanel.add(ConnectionDetailsView.createSeparator());
            this.myHeadersPanel.add(ConnectionDetailsView.createHeaderSection("Request Headers", httpData.getRequestHeaders()));
            this.myStackTraceView.getModel().setStackFrames(ThreadId.INVALID_THREAD_ID, (List<CodeLocation>)httpData.getStackTrace().getCodeLocations());
        } else {
            this.myStackTraceView.getModel().clearStackFrames();
        }
        this.setVisible(httpData != null);
        this.revalidate();
        this.repaint();
    }

    private static JSeparator createSeparator() {
        JSeparator separator = new JSeparator();
        separator.setForeground(UIManager.getColor("Table.gridColor"));
        return separator;
    }

    private static JComponent createFields(@NotNull HttpData httpData, @Nullable Dimension payloadDimension) {
        String contentLength;
        JPanel myFieldsPanel = new JPanel((LayoutManager)new TabularLayout("Fit,20px,*").setVGap(SECTION_VGAP));
        int row = 0;
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Request")), new TabularLayout.Constraint(row, 0));
        myFieldsPanel.add((Component)new JLabel(HttpData.getUrlName(httpData.getUrl())), new TabularLayout.Constraint(row, 2));
        myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Method")), new TabularLayout.Constraint(++row, 0));
        myFieldsPanel.add((Component)new JLabel(httpData.getMethod()), new TabularLayout.Constraint(row, 2));
        if (httpData.getStatusCode() != -1) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Status")), new TabularLayout.Constraint(++row, 0));
            JLabel statusCode = new JLabel(String.valueOf(httpData.getStatusCode()));
            statusCode.setName("StatusCode");
            myFieldsPanel.add((Component)statusCode, new TabularLayout.Constraint(row, 2));
        }
        if (payloadDimension != null) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Dimension")), new TabularLayout.Constraint(++row, 0));
            JLabel dimension = new JLabel(String.format("%d x %d", (int)payloadDimension.getWidth(), (int)payloadDimension.getHeight()));
            dimension.setName("Dimension");
            myFieldsPanel.add((Component)dimension, new TabularLayout.Constraint(row, 2));
        }
        if (httpData.getContentType() != null) {
            myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Content type")), new TabularLayout.Constraint(++row, 0));
            JLabel contentTypeLabel = new JLabel(httpData.getContentType().getMimeType());
            contentTypeLabel.setName("Content type");
            myFieldsPanel.add((Component)contentTypeLabel, new TabularLayout.Constraint(row, 2));
        }
        if ((contentLength = httpData.getResponseField("content-length")) != null) {
            contentLength = contentLength.split(";")[0];
            try {
                long number = Long.parseUnsignedLong(contentLength);
                myFieldsPanel.add((Component)((Object)new NoWrapBoldLabel("Size")), new TabularLayout.Constraint(++row, 0));
                JLabel contentLengthLabel = new JLabel(StringUtil.formatFileSize((long)number));
                contentLengthLabel.setName("Size");
                myFieldsPanel.add((Component)contentLengthLabel, new TabularLayout.Constraint(row, 2));
            }
            catch (NumberFormatException number) {
                // empty catch block
            }
        }
        NoWrapBoldLabel urlLabel = new NoWrapBoldLabel("URL");
        urlLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)urlLabel), new TabularLayout.Constraint(++row, 0));
        WrappedHyperlink hyperlink = new WrappedHyperlink(httpData.getUrl());
        hyperlink.setName("URL");
        myFieldsPanel.add((Component)hyperlink, new TabularLayout.Constraint(row, 2));
        ++row;
        JSeparator separator = ConnectionDetailsView.createSeparator();
        separator.setMinimumSize(separator.getPreferredSize());
        int gap = PAGE_VGAP - SECTION_VGAP - (int)separator.getPreferredSize().getHeight() / 2;
        JPanel separatorContainer = new JPanel((LayoutManager)new VerticalFlowLayout(0, gap));
        separatorContainer.add(separator);
        myFieldsPanel.add((Component)separatorContainer, new TabularLayout.Constraint(row, 0, 1, 3));
        NoWrapBoldLabel timingLabel = new NoWrapBoldLabel("Timing");
        timingLabel.setVerticalAlignment(1);
        myFieldsPanel.add((Component)((Object)timingLabel), new TabularLayout.Constraint(++row, 0));
        myFieldsPanel.add((Component)ConnectionDetailsView.createTimingBar(httpData), new TabularLayout.Constraint(row, 2));
        new TreeWalker((Component)myFieldsPanel).descendantStream().forEach(c -> ConnectionDetailsView.adjustFont(c));
        myFieldsPanel.setName("Response fields");
        return myFieldsPanel;
    }

    @NotNull
    private static JComponent createTimingBar(@NotNull HttpData httpData) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Range range = new Range((double)httpData.getStartTimeUs(), httpData.getEndTimeUs() > 0L ? (double)httpData.getEndTimeUs() : (double)(httpData.getStartTimeUs() + 1L));
        ConnectionsStateChart connectionsChart = new ConnectionsStateChart(httpData, range);
        connectionsChart.getComponent().setMinimumSize(new Dimension(0, JBUI.scale((int)28)));
        connectionsChart.setHeightGap(0.0f);
        panel.add(connectionsChart.getComponent());
        long sentTime = -1L;
        long receivedTime = -1L;
        if (httpData.getDownloadingTimeUs() > 0L) {
            sentTime = httpData.getDownloadingTimeUs() - httpData.getStartTimeUs();
            receivedTime = httpData.getEndTimeUs() - httpData.getDownloadingTimeUs();
        } else if (httpData.getEndTimeUs() > 0L) {
            sentTime = httpData.getEndTimeUs() - httpData.getStartTimeUs();
            receivedTime = 0L;
        }
        FixedLegend sentLegend = new FixedLegend("Sent", TIME_FORMATTER.apply(sentTime));
        FixedLegend receivedLegend = new FixedLegend("Received", TIME_FORMATTER.apply(receivedTime));
        LegendComponentModel legendModel = new LegendComponentModel(100);
        legendModel.add((Legend)sentLegend);
        legendModel.add((Legend)receivedLegend);
        LegendComponent legend = new LegendComponent.Builder(legendModel).setLeftPadding(0).setVerticalPadding(JBUI.scale((int)8)).build();
        legend.setFont(legend.getFont().deriveFont(11.0f));
        legend.configure((Legend)sentLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.SENDING)));
        legend.configure((Legend)receivedLegend, new LegendConfig(LegendConfig.IconType.BOX, connectionsChart.getColors().getColor((Enum)NetworkState.RECEIVING)));
        legendModel.update(1L);
        panel.add((Component)legend);
        panel.setName("Timing");
        return panel;
    }

    @NotNull
    private static JPanel createHeaderSection(@NotNull String title, @NotNull Map<String, String> map) {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("*").setVGap(SECTION_VGAP));
        panel.setBorder(BorderFactory.createEmptyBorder(0, HGAP, 0, 0));
        NoWrapBoldLabel titleLabel = new NoWrapBoldLabel(title);
        ((JComponent)((Object)titleLabel)).setFont(((Component)((Object)titleLabel)).getFont().deriveFont(14.0f));
        panel.add((Component)((Object)titleLabel), new TabularLayout.Constraint(0, 0));
        if (map.isEmpty()) {
            JLabel emptyLabel = new JLabel("No data available");
            panel.add((Component)emptyLabel, new TabularLayout.Constraint(1, 0));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<html>");
            TreeMap<String, String> sortedMap = new TreeMap<String, String>(map);
            for (Map.Entry entry : sortedMap.entrySet()) {
                stringBuilder.append("<p><nobr><b>").append((String)entry.getKey()).append(":&nbsp&nbsp</b></nobr>");
                stringBuilder.append("<span>").append((String)entry.getValue()).append("</span></p>");
            }
            stringBuilder.append("</html>");
            JTextPane pane = ConnectionDetailsView.createTextPane(stringBuilder.toString());
            panel.add((Component)pane, new TabularLayout.Constraint(1, 0));
        }
        new TreeWalker((Component)panel).descendantStream().forEach(arg_0 -> ConnectionDetailsView.lambda$createHeaderSection$4((JLabel)((Object)titleLabel), arg_0));
        panel.setName(title);
        return panel;
    }

    private static JTextPane createTextPane(String text) {
        JTextPane textPane = new JTextPane();
        textPane.setContentType("text/html");
        textPane.setBackground(null);
        textPane.setBorder(null);
        textPane.setEditable(false);
        textPane.setText(text);
        Font labelFont = UIManager.getFont("Label.font");
        String rule = "body { font-family: " + labelFont.getFamily() + "; font-size: " + 11.0f + "pt; }";
        ((HTMLDocument)textPane.getDocument()).getStyleSheet().addRule(rule);
        return textPane;
    }

    private static void adjustFont(@NotNull Component c) {
        if (c.getFont() == null) {
            return;
        }
        c.setFont(c.getFont().deriveFont(0, 11.0f));
    }

    @NotNull
    public StackTraceView getStackTraceView() {
        return this.myStackTraceView;
    }

    private static /* synthetic */ void lambda$createHeaderSection$4(JLabel titleLabel, Component c) {
        if (c != titleLabel) {
            ConnectionDetailsView.adjustFont(c);
        }
    }

    private static class WrappedHyperlink
    extends JTextArea {
        public WrappedHyperlink(@NotNull String url) {
            super(url);
            this.setLineWrap(true);
            this.setEditable(false);
            this.setBackground(UIUtil.getLabelBackground());
            this.setFont(UIManager.getFont("Label.font").deriveFont(11.0f).deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)ImmutableMap.of((Object)TextAttribute.FOREGROUND, (Object)PlatformColors.BLUE, (Object)TextAttribute.BACKGROUND, (Object)UIUtil.getLabelBackground())));
            MouseAdapter mouseAdapter = this.getMouseAdapter(url);
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
        }

        private MouseAdapter getMouseAdapter(final String url) {
            return new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.mouseMoved(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.setCursor(Cursor.getDefaultCursor());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.isMouseOverText(e)) {
                        BrowserUtil.browse((String)url);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.setCursor(this.isMouseOverText(e) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
                }

                private boolean isMouseOverText(MouseEvent e) {
                    return this.viewToModel(e.getPoint()) < this.getDocument().getLength();
                }
            };
        }
    }

    private static final class NoWrapBoldLabel
    extends BoldLabel {
        public NoWrapBoldLabel(String text) {
            super("<nobr>" + text + "</nobr>");
        }
    }
}

