/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.AxisComponentModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.network.ConnectionsStateChart;
import com.android.tools.profilers.network.HoverRowTable;
import com.android.tools.profilers.network.HttpData;
import com.android.tools.profilers.network.HttpDataFetcher;
import com.android.tools.profilers.network.NetworkProfilerAspect;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkProfilerStageView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

final class ConnectionsView {
    @NotNull
    private final NetworkProfilerStage myStage;
    @NotNull
    private final ConnectionsTableModel myTableModel;
    @NotNull
    private final JTable myConnectionsTable;
    @NotNull
    private final AspectObserver myAspectObserver;

    public ConnectionsView(@NotNull NetworkProfilerStageView stageView) {
        this.myStage = (NetworkProfilerStage)stageView.getStage();
        this.myTableModel = new ConnectionsTableModel(this.myStage.getHttpDataFetcher());
        this.myConnectionsTable = new HoverRowTable(this.myTableModel, ProfilerColors.DEFAULT_HOVER_COLOR);
        this.customizeConnectionsTable();
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)NetworkProfilerAspect.SELECTED_CONNECTION, this::updateTableSelection);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myConnectionsTable;
    }

    private static void setTableHeaderBorder(@NotNull JTable table, final @NotNull Border border) {
        final TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            column.setHeaderRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(2);
                    }
                    if (c instanceof JComponent) {
                        ((JComponent)c).setBorder(border);
                    }
                    return c;
                }
            });
        }
    }

    private void customizeConnectionsTable() {
        this.myConnectionsTable.setAutoCreateRowSorter(true);
        this.myConnectionsTable.getColumnModel().getColumn(Column.NAME.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.SIZE.ordinal()).setCellRenderer(new SizeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TYPE.ordinal()).setCellRenderer(new BorderlessTableCellRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.STATUS.ordinal()).setCellRenderer(new StatusRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIME.ordinal()).setCellRenderer(new TimeRenderer());
        this.myConnectionsTable.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setCellRenderer(new TimelineRenderer(this.myConnectionsTable, this.myStage.getStudioProfilers().getTimeline().getSelectionRange()));
        ConnectionsView.setTableHeaderBorder(this.myConnectionsTable, ProfilerLayout.TABLE_COLUMN_HEADER_BORDER);
        this.myConnectionsTable.setSelectionMode(0);
        this.myConnectionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int selectedRow = this.myConnectionsTable.getSelectedRow();
            if (0 <= selectedRow && selectedRow < this.myTableModel.getRowCount()) {
                int modelRow = this.myConnectionsTable.convertRowIndexToModel(selectedRow);
                this.myStage.setSelectedConnection(this.myTableModel.getHttpData(modelRow));
            }
        });
        this.myConnectionsTable.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myConnectionsTable.setShowVerticalLines(true);
        this.myConnectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.myConnectionsTable.getFontMetrics(this.myConnectionsTable.getFont()).getHeight();
        this.myConnectionsTable.setRowMargin(0);
        this.myConnectionsTable.setRowHeight(defaultFontHeight + ProfilerLayout.ROW_HEIGHT_PADDING);
        this.myConnectionsTable.setFocusTraversalKeys(0, null);
        this.myConnectionsTable.setFocusTraversalKeys(1, null);
        this.myConnectionsTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                for (int i = 0; i < Column.values().length; ++i) {
                    Column column = Column.values()[i];
                    ConnectionsView.this.myConnectionsTable.getColumnModel().getColumn(i).setPreferredWidth((int)((double)ConnectionsView.this.myConnectionsTable.getWidth() * column.getWidthPercentage()));
                }
            }
        });
        this.myStage.getHttpDataFetcher().addListener(httpDataList -> this.updateTableSelection());
    }

    private void updateTableSelection() {
        HttpData selectedData = this.myStage.getSelectedConnection();
        if (selectedData != null) {
            for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
                if (this.myTableModel.getHttpData(i).getId() != selectedData.getId()) continue;
                int row = this.myConnectionsTable.convertRowIndexToView(i);
                this.myConnectionsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.myConnectionsTable.clearSelection();
        }
    }

    private final class TimelineRenderer
    implements TableCellRenderer,
    TableModelListener {
        @NotNull
        private final List<ConnectionsStateChart> myConnectionsCharts = new ArrayList<ConnectionsStateChart>();
        @NotNull
        private final JTable myTable;
        @NotNull
        private final Range myRange;

        TimelineRenderer(@NotNull JTable table, Range range) {
            this.myTable = table;
            this.myRange = range;
            this.myTable.getModel().addTableModelListener(this);
            this.tableChanged(new TableModelEvent(this.myTable.getModel()));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ConnectionsStateChart chart = this.myConnectionsCharts.get(this.myTable.convertRowIndexToModel(row));
            chart.getColors().setColorIndex(isSelected ? 1 : 0);
            JBPanel panel = new JBPanel((LayoutManager)new TabularLayout("*", "*"));
            if (row == 0) {
                AxisComponent axisLabels = this.createAxis();
                axisLabels.setMarkerLengths(0, 0);
                panel.add((Component)axisLabels, new TabularLayout.Constraint(0, 0));
            }
            panel.add((Component)chart.getComponent(), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = this.createAxis();
            axisTicks.setMarkerLengths(this.myTable.getRowHeight(), 0);
            axisTicks.setShowLabels(false);
            panel.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.myConnectionsCharts.clear();
            ConnectionsTableModel model = (ConnectionsTableModel)this.myTable.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                ConnectionsStateChart chart = new ConnectionsStateChart(model.getHttpData(i), this.myRange);
                chart.setHeightGap(0.3f);
                this.myConnectionsCharts.add(chart);
            }
        }

        @NotNull
        private AxisComponent createAxis() {
            AxisComponentModel model = new AxisComponentModel(this.myRange, (BaseAxisFormatter)new TimeAxisFormatter(1, 4, 1));
            model.setClampToMajorTicks(false);
            model.setGlobalRange(ConnectionsView.this.myStage.getStudioProfilers().getTimeline().getDataRange());
            AxisComponent axis = new AxisComponent(model, AxisComponent.AxisOrientation.BOTTOM);
            axis.setShowAxisLine(false);
            axis.setMarkerColor(ProfilerColors.NETWORK_TABLE_AXIS);
            model.update(1L);
            return axis;
        }
    }

    private static final class TimeRenderer
    extends BorderlessTableCellRenderer {
        private TimeRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Long durationUs = (Long)value;
            if (durationUs >= 0L) {
                long durationMs = TimeUnit.MICROSECONDS.toMillis(durationUs);
                this.setText(StringUtil.formatDuration((long)durationMs));
            } else {
                this.setText("");
            }
        }
    }

    private static final class StatusRenderer
    extends BorderlessTableCellRenderer {
        private StatusRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            Integer status = (Integer)value;
            this.setText(status > -1 ? Integer.toString(status) : "");
        }
    }

    private static final class SizeRenderer
    extends BorderlessTableCellRenderer {
        private SizeRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            int bytes = (Integer)value;
            this.setText(bytes >= 0 ? StringUtil.formatFileSize((long)bytes) : "");
        }
    }

    private static class BorderlessTableCellRenderer
    extends DefaultTableCellRenderer {
        private BorderlessTableCellRenderer() {
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(new EmptyBorder(ProfilerLayout.TABLE_COLUMN_CELL_INSETS));
        }
    }

    private final class ConnectionsTableModel
    extends AbstractTableModel {
        @NotNull
        private List<HttpData> myDataList = new ArrayList<HttpData>();

        private ConnectionsTableModel(HttpDataFetcher httpDataFetcher) {
            httpDataFetcher.addListener(httpDataList -> {
                this.myDataList = httpDataList;
                this.fireTableDataChanged();
            });
        }

        @Override
        public int getRowCount() {
            return this.myDataList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return Column.values()[column].toDisplayString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            HttpData data = this.myDataList.get(rowIndex);
            return Column.values()[columnIndex].getValueFrom(data);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Column.values()[columnIndex].getType();
        }

        @NotNull
        public HttpData getHttpData(int rowIndex) {
            return this.myDataList.get(rowIndex);
        }
    }

    @VisibleForTesting
    static enum Column {
        NAME(0.25, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return HttpData.getUrlName(data.getUrl());
            }
        }
        ,
        SIZE(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                String contentLength = data.getResponseField("content-length");
                return contentLength != null ? Integer.parseInt(contentLength) : -1;
            }
        }
        ,
        TYPE(0.0625, (Class)String.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                HttpData.ContentType type = data.getContentType();
                return type == null ? "" : type.getMimeType();
            }
        }
        ,
        STATUS(0.0625, (Class)Integer.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getStatusCode();
            }
        }
        ,
        TIME(0.0625, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getEndTimeUs() - data.getStartTimeUs();
            }
        }
        ,
        TIMELINE(0.5, (Class)Long.class){

            @Override
            Object getValueFrom(@NotNull HttpData data) {
                return data.getStartTimeUs();
            }
        };

        private final double myWidthPercentage;
        private final Class<?> myType;

        private Column(double widthPercentage, Class<?> type) {
            this.myWidthPercentage = widthPercentage;
            this.myType = type;
        }

        public double getWidthPercentage() {
            return this.myWidthPercentage;
        }

        public Class<?> getType() {
            return this.myType;
        }

        public String toDisplayString() {
            return StringUtil.capitalize((String)this.name().toLowerCase(Locale.getDefault()));
        }

        abstract Object getValueFrom(@NotNull HttpData var1);
    }
}

